package com.netacom.full.ui.main.chat.adapter

import android.content.Context
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadFullImage
import com.netacom.base.chat.util.getDimension
import com.netacom.full.R
import com.netacom.full.databinding.ItemPhotoInChatRowBinding
import com.netacom.lite.entity.ui.message.NeImage
import com.netacom.lite.entity.ui.message.NeMessage

class PhotoMessageAdapter(
    private val context: Context,
    private val message: NeMessage,
    private val column: Int,
    private val imageClick: ((Int, NeImage) -> Unit),
    private val imageLongClick: (() -> Unit)
) : BaseListSimpleAdapter<NeImage, ItemPhotoInChatRowBinding>(diff = NeImageDiffUtilCallback()) {

    override fun bind(item: NeImage, holder: BaseViewHolder<ItemPhotoInChatRowBinding>, position: Int) {
        with(holder.binding) {
            neMessage = message
            index = position
            ivPhotoItem.requestLayout()
            if (column == 2) {
                ivPhotoItem.layoutParams.width = context.getDimension(R.dimen.dp_120).toInt()
                ivPhotoItem.layoutParams.height = context.getDimension(R.dimen.dp_120).toInt()
            } else if (column == 3) {
                ivPhotoItem.layoutParams.width = context.getDimension(R.dimen.dp_90).toInt()
                ivPhotoItem.layoutParams.height = context.getDimension(R.dimen.dp_90).toInt()
            }
            if (message.isEncrypted) {
                if (item.isLoading) {
                    progressBar.isVisible = true
                } else {
                    progressBar.isGone = true
                    ivPhotoItem.loadFullImage(item.url)
                }
            } else {
                progressBar.isGone = true
                ivPhotoItem.loadFullImage(item.url)
            }
            ivPhotoItem.clickDebounce {
                imageClick(position, item)
            }
            ivPhotoItem.setOnLongClickListener {
                imageLongClick()
                false
            }
        }
    }

    override val layout: Int = R.layout.item_photo_in_chat_row

    private class NeImageDiffUtilCallback : DiffUtil.ItemCallback<NeImage>() {

        override fun areItemsTheSame(oldItem: NeImage, newItem: NeImage): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(oldItem: NeImage, newItem: NeImage): Boolean {
            return oldItem.url == newItem.url && oldItem.index == newItem.index
        }
    }
}
