package com.netacom.full.ui.main.chat.adapter

import android.view.View
import android.view.ViewGroup
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseMultiTypeListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.full.R
import com.netacom.full.databinding.ItemContactBinding
import com.netacom.full.databinding.ItemRcvUserGroupHeaderBinding
import com.netacom.full.ui.main.contact.model.SubNeContact
import com.netacom.lite.entity.ui.user.NeUser

class RegisteredUserAdapter(itemClick: (SubNeContact, View, Int) -> Unit) : BaseMultiTypeListSimpleAdapter<SubNeContact, ViewDataBinding>(itemClick, diff = ContactDiff()) {

    companion object {
        private const val CONTACT_HEADER = 0
        private const val CONTACT_BODY = 1
    }

    override fun bindMultiType(position: Int): Int {
        return when {
            itemCount == 0 -> 0
            getData[position].isHeader() -> CONTACT_HEADER
            else -> CONTACT_BODY
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        return when (viewType) {
            CONTACT_HEADER -> BaseViewHolder(
                inflateView(parent, R.layout.item_rcv_user_group_header) as ItemRcvUserGroupHeaderBinding
            )
            CONTACT_BODY -> BaseViewHolder(
                inflateView(parent, R.layout.item_contact) as ItemContactBinding
            )
            else -> BaseViewHolder(inflateView(parent, R.layout.item_contact) as ItemContactBinding)
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        getItem(position)?.apply {
            with(holder) {
                when (getItemViewType(position)) {
                    CONTACT_HEADER -> bindContactHeader(this, subNeContact = this@apply)
                    CONTACT_BODY -> bindContactBody(
                        this,
                        neContact = _itemNeContact?._neContact,
                        isDivider = (layoutPosition != (itemCount - 1))
                    )
                }
                binding.executePendingBindings()
            }
        }
    }

    private fun bindContactHeader(
        holder: BaseViewHolder<ViewDataBinding>,
        subNeContact: SubNeContact
    ) {
        with(holder.binding as ItemRcvUserGroupHeaderBinding) {
            this.header = subNeContact._neHeader ?: "#"
        }
    }

    private fun bindContactBody(holder: BaseViewHolder<ViewDataBinding>, neContact: NeUser?, isDivider: Boolean) {
        with(holder.binding as ItemContactBinding) {
            this.item = neContact
            this.hasDivider = isDivider
        }
    }

    private class ContactDiff : DiffUtil.ItemCallback<SubNeContact>() {
        override fun areItemsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            return if (oldItem.isHeader() && newItem.isHeader()) {
                true
            } else !oldItem.isHeader() && !newItem.isHeader()
        }

        override fun areContentsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            return if (oldItem.isHeader() && newItem.isHeader() && oldItem._neHeader == newItem._neHeader) {
                true
            } else (
                !oldItem.isHeader() && !newItem.isHeader() &&
                    oldItem._itemNeContact?._neContact?.phone == newItem._itemNeContact?._neContact?.phone &&
                    oldItem._itemNeContact?._neContact?.getDisplayName == newItem._itemNeContact?._neContact?.getDisplayName &&
                    oldItem._itemNeContact?._neContact?.getDisplayAvatar == newItem._itemNeContact?._neContact?.getDisplayAvatar
                )
        }
    }
}
