package com.netacom.full.ui.main.chat.adapter.sticker

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.core.view.get
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.viewpager.widget.PagerAdapter
import com.netacom.full.R
import com.netacom.lite.entity.ui.NeSticker
import com.netacom.lite.entity.ui.SubNeCategory

class DCategoryStickerAdapter(private val context: Context) : PagerAdapter() {

    // This holds all the currently displayable views, in order from left to right.
    private val views = mutableListOf<View>()
    private val subNeCategories = mutableListOf<SubNeCategory>()

    private lateinit var stickerAdapter: StickerAdapter

    fun setPageData(subNeCategories: List<SubNeCategory>) {
        this.subNeCategories.clear()
        this.subNeCategories.addAll(subNeCategories)
        views.clear()
        for (i in subNeCategories.indices) {
            views.add(FrameLayout(context))
        }
        notifyDataSetChanged()
    }

    // -----------------------------------------------------------------------------
    // Used by ViewPager.  "Object" represents the page; tell the ViewPager where the
    // page should be displayed, from left-to-right.  If the page no longer exists,
    // return POSITION_NONE.
    override fun getItemPosition(`object`: Any): Int {
        val index = views.indexOf(`object`)
        return if (index == -1) {
            POSITION_NONE
        } else {
            index
        }
    }

    // -----------------------------------------------------------------------------
    // Used by ViewPager.  Called when ViewPager needs a page to display; it is our job
    // to add the page to the container, which is normally the ViewPager itself.  Since
    // all our pages are persistent, we simply retrieve it from our "views" ArrayList.
    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val v = views[position]
        container.addView(v)
        return v
    }

    // -----------------------------------------------------------------------------
    // Used by ViewPager.  Called when ViewPager no longer needs a page to display; it
    // is our job to remove the page from the container, which is normally the
    // ViewPager itself.  Since all our pages are persistent, we do nothing to the
    // contents of our "views" ArrayList.
    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        container.removeView(views[position])
    }

    // -----------------------------------------------------------------------------
    // Used by ViewPager; can be used by app as well.
    // Returns the total number of pages that the ViewPage can display.  This must
    // never be 0.
    override fun getCount(): Int {
        return views.size
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view == `object`
    }

    private val spanCount = 4
    fun initView(position: Int) {

        val action: (Int) -> Unit = { pos ->
            val pView = views[pos]
            if (pView.tag != pos.toString()) {
                val view = LayoutInflater.from(context).inflate(R.layout.pager_category_sticker, null)
                val rcvSticker: RecyclerView = view.findViewById(R.id.rcv_sticker)
                rcvSticker.layoutManager = GridLayoutManager(context, spanCount)
                stickerAdapter = StickerAdapter(
                    context = context,
                    spanCount = spanCount,
                    stickerClick = {
                        val time = System.currentTimeMillis()
                        addStickerClickToRecent(neSticker = it, time = time)
                        stickerClickListener?.onClick(neSticker = it, time = time)
                    },
                    { _, _, _ ->
                    },
                )

                stickerAdapter.display(subNeCategories[pos].neCategory.stickers ?: emptyList())

                rcvSticker.adapter = stickerAdapter

                view.tag = pos.toString()
                views[pos] = view
            }
        }

        action(position)
        notifyDataSetChanged()
    }

    private fun addStickerClickToRecent(neSticker: NeSticker, time: Long) {
        subNeCategories[0].neCategory.stickers?.let {
            if (it.contains(neSticker)) {
                it.remove(neSticker)
            }
            neSticker.sentTime = time
            it.add(0, neSticker)

            if (views[0].tag == "0") {
                (((views[0] as? FrameLayout)?.get(0) as? RecyclerView)?.adapter as? StickerAdapter)?.display(it)
            }
        }
    }

    private var stickerClickListener: StickerClickListener? = null
    fun setOnStickerClick(stickerClickListener: StickerClickListener) {
        this.stickerClickListener = stickerClickListener
    }

    interface StickerClickListener {
        fun onClick(neSticker: NeSticker) {}

        fun onClick(neSticker: NeSticker, time: Long) {}
    }
}
