package com.netacom.full.ui.main.chat.adapter.sticker

import android.content.Context
import android.view.View
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.GridLayoutManager
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvStickerBinding
import com.netacom.lite.entity.ui.NeSticker
import com.netacom.lite.util.AppUtils

class StickerAdapter(
    private val context: Context,
    private val spanCount: Int,
    private val stickerClick: ((NeSticker) -> Unit),
    itemClick: ((NeSticker, View, Int) -> Unit)?
) : BaseListSimpleAdapter<NeSticker, ItemRcvStickerBinding>(itemClick, diff = NeStickerDiffUtilCallback()) {

    private var stickerSize: Int = 0
    private var dp10 = context.resources.getDimensionPixelSize(R.dimen.dp_10)

    init {
        stickerSize = (AppUtils.getWidth(context) - (spanCount + 1) * dp10) / spanCount
    }

    override fun bind(item: NeSticker, holder: BaseViewHolder<ItemRcvStickerBinding>, position: Int) {
        with(holder.binding) {
            this.item = item
            setupLayout(holder.itemView, position)
            ivSticker.clickDebounce {
                stickerClick(item)
            }
        }
    }

    private fun setupLayout(view: View, position: Int) {
        (view.layoutParams as? GridLayoutManager.LayoutParams)?.let { layoutParams ->
            layoutParams.width = stickerSize
            layoutParams.height = stickerSize
            if (position % spanCount == 0) {
                layoutParams.setMargins(dp10, 0, dp10, dp10)
            } else {
                layoutParams.setMargins(0, 0, dp10, dp10)
            }
        }
    }

    override val layout: Int = R.layout.item_rcv_sticker

    private class NeStickerDiffUtilCallback : DiffUtil.ItemCallback<NeSticker>() {

        override fun areItemsTheSame(oldItem: NeSticker, newItem: NeSticker): Boolean {
            return oldItem.id == newItem.id
        }

        override fun areContentsTheSame(oldItem: NeSticker, newItem: NeSticker): Boolean {
            return oldItem.name == newItem.name
        }
    }
}
