package com.netacom.full.ui.main.chat.adapter.sticker

import android.view.View
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvStickerCategoryBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.SubNeCategory

class StickerCategoryAdapter(
    private val themeHelperImpl: ThemeHelperImpl,
    private val stickerCategoryClick: ((Int) -> Unit),
    itemClick: ((SubNeCategory, View, Int) -> Unit)?
) : BaseListSimpleAdapter<SubNeCategory, ItemRcvStickerCategoryBinding>(itemClick, diff = NeStickerCategoryDiffUtilCallback()) {

    private var dp4 = Utils.getApp().resources.getDimensionPixelSize(R.dimen.dp_4)
    private var dp6 = Utils.getApp().resources.getDimensionPixelSize(R.dimen.dp_6)
    private var dp10 = Utils.getApp().resources.getDimensionPixelSize(R.dimen.dp_10)

    private var lastItemSelect = -1

    override fun bind(item: SubNeCategory, holder: BaseViewHolder<ItemRcvStickerCategoryBinding>, position: Int) {
        with(holder.binding) {
            if (item.isSelect) {
                lastItemSelect = position
                flRoot.setBackgroundResource(R.drawable.bg_sticker_category_select)
            } else {
                flRoot.setBackgroundResource(android.R.color.transparent)
            }
            if (position == 0) {
                ivCategory.setPadding(dp6, 0, dp6, 0)
                ivCategory.setImageResource(R.drawable.ic_sticker_recently)
                themeHelperImpl.setThemeColorForViews(ivCategory)
            } else {
                ivCategory.imageTintList = null
                ivCategory.setPadding(dp10, dp4, dp10, dp4)
                ivCategory.loadImage(item.neCategory.imageUrl)
            }
            ivCategory.clickDebounce {
                if (position != lastItemSelect) {
                    getItem(position)?.apply {
                        isSelect = true
                        if (lastItemSelect != -1) {
                            getItem(lastItemSelect)?.isSelect = false
                            notifyItemChanged(lastItemSelect, getItem(lastItemSelect))
                        }
                        lastItemSelect = position
                        notifyItemChanged(position, this)
                        stickerCategoryClick(position)
                    }
                }
            }
        }
    }

    fun setSelect(position: Int) {
        val items = getData
        if (position < items.size && position != lastItemSelect) {
            items[position].isSelect = true
            if (lastItemSelect != -1) {
                items[lastItemSelect].isSelect = false
                notifyItemChanged(lastItemSelect, items[lastItemSelect])
            }
            lastItemSelect = position
            notifyItemChanged(position, items[position])
        }
    }

    override val layout: Int = R.layout.item_rcv_sticker_category

    private class NeStickerCategoryDiffUtilCallback : DiffUtil.ItemCallback<SubNeCategory>() {

        override fun areItemsTheSame(oldItem: SubNeCategory, newItem: SubNeCategory): Boolean {
            return oldItem.neCategory == newItem.neCategory
        }

        override fun areContentsTheSame(oldItem: SubNeCategory, newItem: SubNeCategory): Boolean {
            return oldItem.neCategory.id == newItem.neCategory.id
        }
    }
}
