package com.netacom.full.ui.main.chat.viewholder

import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageAudioSenderBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.AudioSupport
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants

class MessageAudioSenderViewHolder(
    val _binding: RowMessageAudioSenderBinding,
    val themeHelperImpl: ThemeHelperImpl,
    private val contentClickListener: AbstractItemClickListener,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(message: NeMessage?, messagePosition: MessagePosition, userToken: String) {
        message?.let { item ->
            _binding.item = item
            _binding.messagePosition = messagePosition

            AppUtils.setAudioTextViewTag(view = _binding.txtProgress, time = item.attachment?.audio?.duration ?: 0)
            when (AudioSupport.messageId) {
                item.id?.toLongOrNull() -> {
                    AudioSupport.setViewPlayer(view = _binding.root)
                    _binding.imgPlay.setImageResource(R.drawable.ic_record_pause)
                }
                else -> {
                    if (AudioSupport.audioView?.toString() == _binding.root.toString()) {
                        AudioSupport.audioView = null
                    }
                    _binding.imgPlay.setImageResource(R.drawable.ic_record_play)
                    _binding.seekbar.progress = 0
                    item.attachment?.audio?.apply {
                        _binding.txtProgress.text = AppUtils.setAudioTextViewTime(time = this.duration ?: 0)
                    }
                }
            }

            _binding.tvSenderTime.text = DateTimeUtils.ParseDateTimeToString.parseJustTime(DateTimeUtils.getMillisFromNano(item.createAt))

            themeHelperImpl.setThemeColorForMessage(_binding.ctlContainer, ChatMessageType.MY_MESSAGE_AUDIO, groupType)

            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.imgPlay, _binding.imgSend, _binding.seekbar)
            } else {
                themeHelperImpl.setThemeColorForViews(_binding.imgPlay, _binding.seekbar)
                if (message.status == MessageStatusType.MESSAGE_SEEN) {
                    themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                } else {
                    _binding.imgSend.imageTintList = null
                }
            }
            setupPlayAction(item, userToken, groupType == GroupType.GROUP_TYPE_PRIVATE)
        }
    }

    private fun setupPlayAction(item: NeMessage, userToken: String, isEncrypt: Boolean) {
        _binding.imgPlay.clickDebounce {
            if (isEncrypt) {
                val localAudioSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}/0"
                if (FileUtils.isFileExists(localAudioSecretPath)) {
                    actionAudio(item, userToken, localAudioSecretPath)
                } else {
                    actionAudio(item, userToken, item.attachment?.audio?.url ?: Constants.EMPTY)
                }
            } else {
                actionAudio(item, userToken, item.attachment?.audio?.url ?: Constants.EMPTY)
            }
        }
    }

    private fun actionAudio(item: NeMessage, userToken: String, url: String) {
        if (AudioSupport.messageId == item.id?.toLongOrNull() &&
            (AudioSupport.status == AudioSupport.AudioStatus.STATUS_PLAYING || AudioSupport.status == AudioSupport.AudioStatus.STATUS_LOADING)
        ) {
            /**
             * This audio play -> pause
             * */
            AudioSupport.stopAudio()
        } else if (AudioSupport.messageId != item.id?.toLongOrNull() &&
            (AudioSupport.status == AudioSupport.AudioStatus.STATUS_PLAYING || AudioSupport.status == AudioSupport.AudioStatus.STATUS_LOADING)
        ) {
            /**
             * Other audio play -> pause
             * This audio pause -> play
             * */
            AudioSupport.stopAudio()

            AudioSupport.setViewPlayer(view = _binding.root)
            AudioSupport.playAudio(
                context = _binding.root.context,
                messageId = item.id?.toLongOrNull(),
                audioUrl = url,
                userToken = userToken
            )
        } else {
            /**
             * Play this audio
             * */
            AudioSupport.setViewPlayer(view = _binding.root)
            AudioSupport.playAudio(
                context = _binding.root.context,
                messageId = item.id?.toLongOrNull(),
                audioUrl = url,
                userToken = userToken
            )
        }
    }
}
