package com.netacom.full.ui.main.chat.viewholder

import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.databinding.RowMessageCallIncomeBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser

class MessageCallInComeViewHolder(
    private val _binding: RowMessageCallIncomeBinding,
    private val contentClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        isVoice: Boolean,
        isCallSuccess: Boolean,
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?
    ) {
        _binding.isVoice = isVoice
        _binding.isCallSuccess = isCallSuccess
        _binding.item = item
        _binding.messagePosition = messagePosition
        _binding.isShowName = false
        _binding.receiverColor = themeHelperImpl.mainColor

        themeHelperImpl.setThemeColorForMessage(_binding.ctlContainer, ChatMessageType.PARTNER_MESSAGE_CALL, groupType)

        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgCallAction)
        } else {
            themeHelperImpl.setThemeColorForViews(_binding.imgCallAction)
        }

        _binding.ctlContainer.clickDebounce {
            contentClickListener.onCallClicked(item, isVoice)
        }
    }
}
