package com.netacom.full.ui.main.chat.viewholder

import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.databinding.RowMessageCallOutcomeBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser

class MessageCallOutComeViewHolder(
    private val _binding: RowMessageCallOutcomeBinding,
    private val abstractItemClickListener: AbstractItemClickListener?,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        isVoice: Boolean,
        isCallSuccess: Boolean,
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?
    ) {
        _binding.isVoice = isVoice
        _binding.isCallSuccess = isCallSuccess
        _binding.item = item
        _binding.messagePosition = messagePosition

        themeHelperImpl.setThemeColorForMessage(_binding.ctlContainer, ChatMessageType.MY_MESSAGE_CALL, groupType)

        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend, _binding.imgCallAction)
        } else {
            themeHelperImpl.setThemeColorForViews(_binding.imgCallAction)
            if (item.status == MessageStatusType.MESSAGE_SEEN) {
                themeHelperImpl.setThemeColorForViews(_binding.imgSend)
            } else {
                _binding.imgSend.imageTintList = null
            }
        }

        _binding.ctlContainer.clickDebounce {
            abstractItemClickListener?.onCallClicked(item, isVoice)
        }
    }
}
