package com.netacom.full.ui.main.chat.viewholder

import android.annotation.SuppressLint
import androidx.core.view.isGone
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageFileReceiverBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser

class MessageFileReceiverViewHolder(
    val _binding: RowMessageFileReceiverBinding,
    private val contentClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {
    @SuppressLint("SetTextI18n")
    fun bind(
        message: NeMessage?,
        messagePosition: MessagePosition,
        members: List<NeUser>?,
        isSingle: Boolean,
        avatarCallback: () -> Unit
    ) {
        message?.let { item ->
            _binding.item = item
            _binding.receiverColor = themeHelperImpl.mainColor
            _binding.ivAvatarReceiver.clickDebounce {
                avatarCallback()
            }

            _binding.rlDocumentContainer.setBackgroundResource(R.drawable.bg_media_receiver)
            _binding.tvReceiverTime.text = DateTimeUtils.ParseDateTimeToString.parseJustTime(DateTimeUtils.getMillisFromNano(item.createAt))

            item.attachment?.file?.let { file ->
                _binding.tvFileName.text = "${file.name}.${file.extension}"
                _binding.tvFileSize.text = file.sizeText

                _binding.rlDocumentContainer.clickDebounce {
                    contentClickListener.onDocumentAction(message.id, file, layoutPosition, false)
                }
            }

            setupMessagePosition(messagePosition, isSingle)

            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.ivDocument)
            } else {
                themeHelperImpl.setThemeColorForViews(_binding.ivDocument)
            }

            themeHelperImpl.setThemeColorForMessage(_binding.rlDocumentContainer, ChatMessageType.PARTNER_MESSAGE_FILE, groupType)
        }
    }

    private fun setupMessagePosition(messagePosition: MessagePosition, isSingle: Boolean) {
        when (messagePosition) {
            MessagePosition.SINGLE -> {
                _binding.isShowName = !isSingle
                _binding.ivAvatarReceiver.isVisible = true
                _binding.vSeparator.isVisible = true
                _binding.tvReceiverTime.isVisible = true
            }
            MessagePosition.TOP -> {
                _binding.isShowName = !isSingle
                _binding.ivAvatarReceiver.isInvisible = true
                _binding.vSeparator.isVisible = true
                _binding.tvReceiverTime.isGone = true
            }
            MessagePosition.MID -> {
                _binding.isShowName = false
                _binding.ivAvatarReceiver.isInvisible = true
                _binding.vSeparator.isGone = true
                _binding.tvReceiverTime.isGone = true
            }
            MessagePosition.BOTTOM -> {
                _binding.isShowName = false
                _binding.ivAvatarReceiver.isVisible = true
                _binding.vSeparator.isGone = true
                _binding.tvReceiverTime.isVisible = true
            }
        }
    }
}
