package com.netacom.full.ui.main.chat.viewholder

import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageFileSenderBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage

class MessageFileSenderViewHolder(
    val _binding: RowMessageFileSenderBinding,
    private val contentClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {
    fun bind(
        message: NeMessage?,
        messagePosition: MessagePosition
    ) {
        message?.let { item ->
            _binding.item = item
            _binding.messagePosition = messagePosition
            _binding.rlDocumentContainer.setBackgroundResource(R.drawable.bg_media_sender)

            item.attachment?.file?.let { file ->
                _binding.rlDocumentContainer.clickDebounce {
                    contentClickListener.onDocumentAction(message.id, file, layoutPosition, false)
                }
            }

            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend, _binding.ivDocument)
            } else {
                themeHelperImpl.setThemeColorForViews(_binding.ivDocument)
                if (item.status == MessageStatusType.MESSAGE_SEEN) {
                    themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                } else {
                    _binding.imgSend.imageTintList = null
                }
            }

            themeHelperImpl.setThemeColorForMessage(_binding.rlDocumentContainer, ChatMessageType.MY_MESSAGE_FILE, groupType)
        }
    }
}
