package com.netacom.full.ui.main.chat.viewholder

import androidx.core.content.ContextCompat
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.ItemFirstMessageBinding
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants

class MessageFirstViewHolder(
    val _binding: ItemFirstMessageBinding,
    private val groupType: Int,
    private val userID: Long
) :
    BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(neMessage: NeMessage, groupName: String? = null, isOneToOne: Boolean = false, members: List<NeUser>?) {
        _binding.item = neMessage
        val context = _binding.root.context
        val nameOfCreator: String = if (neMessage.owner?.id == userID) {
            val accountName = neMessage.owner?.getDisplayName
            String.format(context.resources.getString(R.string.text_message_user_is_you), accountName)
        } else {
            neMessage.owner?.getDisplayName ?: context.resources.getString(R.string.unknown_user)
        }
        val colorApply = ContextCompat.getColor(binding.root.context, R.color.color_item_first_message)
        _binding.txtFirstText.text = when (neMessage.type) {
            MessageType.MESSAGE_TYPE_FIRST_MESSAGE -> {
                if (isOneToOne) {
                    var member = members?.find {
                        it.id != neMessage.owner?.id
                    }
                    val stringId = if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                        if (neMessage.owner?.id == userID) {
                            R.string.message_first_created_secret_Chat_owner
                        } else {
                            member = members?.find {
                                it.id == neMessage.owner?.id
                            }
                            R.string.message_first_created_secret_Chat_partner
                        }
                    } else {
                        R.string.message_first_created
                    }
                    AppUtils.getSpannedText(
                        context.getString(
                            stringId,
                            member?.getDisplayName ?: context.getString(R.string.unknown_user)
                        )
                    )
                } else {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_created,
                            nameOfCreator,
                        )
                    )
                }
            }

            MessageType.MESSAGE_TYPE_SCREENSHOT -> {
                if (neMessage.owner?.id == userID) {
                    AppUtils.getSpannedText(StringUtils.getString(R.string.me_message_capture_screenshot))
                } else {
                    AppUtils.getSpannedText(
                        StringUtils.getString(
                            R.string.message_capture_screenshot,
                            neMessage.owner?.getDisplayName ?: StringUtils.getString(R.string.unknown_user)
                        )
                    )
                }
            }

            MessageType.MESSAGE_TYPE_GROUP_UPDATE -> {
                val changeAvatarGroup = neMessage.attachment?.updatedGroupAvatar
                val changeNameGroup = neMessage.attachment?.updatedGroupName
                val changeBackgroundGroup = neMessage.attachment?.updatedGroupBackground
                val newMembers = neMessage.attachment?.addedUins
                val removeMembers = neMessage.attachment?.removedUin
                val changeOwner = neMessage.attachment?.ownerUin
                val pinMessage = neMessage.attachment?.pin_message
                val unpinMessage = neMessage.attachment?.unpin_message
                val unpinAllMessage = neMessage.attachment?.unpin_all_message
                val updatedMessageDeleteTimer = neMessage.attachment?.updated_message_delete_timer
                if (updatedMessageDeleteTimer.isNotNull) {
                    if (neMessage.attachment?.updated_message_delete_timer == 0) {
                        if (neMessage.owner?.id == userID) {
                            AppUtils.getSpannedText(StringUtils.getString(R.string.last_message_me_clear_time_out_of_secret_chat))
                        } else {
                            AppUtils.getSpannedText(
                                StringUtils.getString(
                                    R.string.last_message_another_clear_time_out_of_secret_chat,
                                    neMessage.owner?.getDisplayName
                                        ?: StringUtils.getString(R.string.unknown_user)
                                )
                            )
                        }
                    } else {
                        if (neMessage.owner?.id == userID) {
                            AppUtils.getSpannedText(
                                StringUtils.getString(
                                    R.string.last_message_me_set_time_out_of_secret_chat,
                                    neMessage.owner?.getDisplayName
                                        ?: StringUtils.getString(R.string.unknown_user),
                                    neMessage.attachment?.updated_message_delete_timer
                                )
                            )
                        } else {
                            AppUtils.getSpannedText(
                                StringUtils.getString(
                                    R.string.last_message_another_set_time_out_of_secret_chat,
                                    neMessage.owner?.getDisplayName
                                        ?: StringUtils.getString(R.string.unknown_user),
                                    neMessage.attachment?.updated_message_delete_timer
                                )
                            )
                        }
                    }
                } else if (!changeAvatarGroup.isNullOrEmpty() && !changeNameGroup.isNullOrEmpty()) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_update_group,
                            nameOfCreator,
                            changeNameGroup
                        )
                    )
                } else if (!changeAvatarGroup.isNullOrEmpty()) {
                    AppUtils.getSpannedText(context.getString(R.string.message_first_group_update_avatar, nameOfCreator))
                } else if (!changeNameGroup.isNullOrEmpty()) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_update_group,
                            nameOfCreator,
                            changeNameGroup
                        )
                    )
                } else if (!newMembers.isNullOrEmpty()) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_update_add,
                            nameOfCreator,
                            neMessage.messageUpdate ?: binding.root.context.resources.getString(R.string.unknown_user)
                        )
                    )
                } else if (removeMembers != null) { // todo refactor
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_update_remove,
                            nameOfCreator,
                            neMessage.messageUpdate ?: binding.root.context.resources.getString(R.string.unknown_user)
                        )
                    )
                } else if (!changeOwner.isNullOrEmpty()) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_update_change_owner,
                            nameOfCreator,
                            neMessage.messageUpdate ?: binding.root.context.resources.getString(R.string.unknown_user)
                        )
                    )
                } else if (pinMessage.isNotNull) {
                    val content = AppUtils.getContentPinMessage(members, pinMessage!!)

                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_pin_messasge,
                            nameOfCreator,
                            content.toString()
                        )
                    )
                } else if (unpinMessage.isNotNull) {
                    val content = AppUtils.getContentPinMessage(members, unpinMessage!!)

                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_unpin_messasge,
                            nameOfCreator,
                            content.toString()
                        )
                    )
                } else if (unpinAllMessage.isNotNull) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_unpin_all_messasge,
                            nameOfCreator
                        )
                    )
                } else if (changeBackgroundGroup.isNotNull) {
                    AppUtils.getSpannedText(
                        context.getString(
                            R.string.message_first_group_update_background,
                            nameOfCreator,
                        )
                    )
                } else Constants.EMPTY
            }
            MessageType.MESSAGE_TYPE_LEAVE_GROUP -> {
                AppUtils.getSpannedText(
                    context.getString(
                        R.string.message_first_group_leave,
                        nameOfCreator,
                    )
                )
            }
            else -> binding.root.context.resources.getString(R.string.unknown_user)
        }
    }
}
