package com.netacom.full.ui.main.chat.viewholder

import android.webkit.URLUtil
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.RowForwardMessageReceiverBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MentionType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.getUrlImage

class MessageForwardReceiverViewHolder(
    val _binding: RowForwardMessageReceiverBinding,
    private val contentClickListener: ItemClickListener?,
    private val abstractClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupRepository: GroupRepository? = null
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?,
        groupType: Int,
        avatarCallback: () -> Unit
    ) {
        _binding.item = item
        _binding.messagePosition = messagePosition
        _binding.groupType = groupType
        _binding.receiverColor = themeHelperImpl.mainColor
        // check event go to web or call
        AppUtils.setupSpannableString(
            view = _binding.textReply,
            type = MentionType.PARTNER,
            input = item.content ?: "",
            neMembers = members ?: emptyList(),
            callback = {
                contentClickListener?.onMentionClick(neMentionPosition = it)
            },
            themeColor = themeHelperImpl.mainColor,
            groupRepository = groupRepository
        )

        item.content?.let { textContent ->
            if (textContent.isNotNull && URLUtil.isValidUrl(textContent)) {
                _binding.newPreview.apply {
                    isVisible = true
                    load(textContent)
                }
            } else {
                _binding.newPreview.isGone = true
            }
        }

        _binding.ivAvatarReceiver.clickDebounce {
            avatarCallback()
        }

        // reply content
        item.attachment?.forwardMessage?.let { neAttachmentMessage ->
            when (neAttachmentMessage.type) {
                MessageType.MESSAGE_TYPE_TEXT -> {
                    AppUtils.setupSpannableString(
                        view = _binding.txtReplyContent,
                        type = MentionType.REPLY,
                        input = neAttachmentMessage.content ?: "",
                        neMembers = members ?: emptyList(),
                        callback = {
                            contentClickListener?.onMentionClick(neMentionPosition = it)
                        },
                        themeColor = themeHelperImpl.mainColor,
                        groupRepository = groupRepository
                    )
                    _binding.txtReplyContent.isVisible = true
                    _binding.rlPhotoReplyContent.isGone = true
                    _binding.ivPlayVideo.isGone = true
                }
                MessageType.MESSAGE_TYPE_IMAGE -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true
                    _binding.ivPlayVideo.isGone = true

                    val images = neAttachmentMessage.attachment?.images?.map {
                        it.url?.getUrlImage()
                    } ?: emptyList()

                    when {
                        images.size == 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.isGone = true
                            _binding.vForwardBlur.isGone = true
                        }

                        images.size > 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.text =
                                String.format(binding.root.context.resources.getString(R.string.message_reply_image_count), images.size)
                            _binding.tvReplyPhotoCount.isVisible = true
                            _binding.vForwardBlur.isVisible = true
                        }

                        else -> {
                            showContentEmpty()
                        }
                    }
                }
                MessageType.MESSAGE_TYPE_VIDEO -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true
                    _binding.ivPlayVideo.isVisible = true

                    val thumbnailUrl = neAttachmentMessage.attachment?.video?.thumbnailUrl?.let {
                        it.getUrlImage()
                    }

                    if (!thumbnailUrl.isNullOrEmpty()) {
                        _binding.ivReplyPhoto.loadImage(thumbnailUrl, corner = 1f)
                        _binding.tvReplyPhotoCount.isGone = true
                        _binding.vForwardBlur.isGone = true
                    } else {
                        showContentEmpty()
                    }
                }
                MessageType.MESSAGE_TYPE_FILE -> {
                    _binding.txtReplyContent.isVisible = true
                    _binding.rlPhotoReplyContent.isGone = true
                    _binding.ivPlayVideo.isGone = true

                    val fileName = neAttachmentMessage.attachment?.file?.name ?: ""
                    val fileExtension = neAttachmentMessage.attachment?.file?.extension ?: ""

                    if (fileName.isNotEmpty()) {
                        _binding.txtReplyContent.text = if (fileExtension.isNotEmpty()) fileName.plus(".$fileExtension") else fileName
                    } else {
                        showContentEmpty()
                    }
                }
                MessageType.MESSAGE_TYPE_LOCATION -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true

                    val thumbnailUrl = neAttachmentMessage.attachment?.location?.image_url?.let {
                        it.getUrlImage()
                    }

                    if (!thumbnailUrl.isNullOrEmpty()) {
                        _binding.ivReplyPhoto.loadImage(thumbnailUrl, corner = 1f)
                        _binding.tvReplyPhotoCount.isGone = true
                        _binding.vForwardBlur.isGone = true
                    } else {
                        showContentEmpty()
                    }
                }
                else -> {
                    showContentEmpty()
                }
            }

            _binding.txtReplyUserName.text = String.format(
                binding.root.context.resources.getString(R.string.message_user_forward),
                item.owner?.getDisplayName
                    ?: binding.root.context.resources.getString(R.string.unknown_user)
            )

            _binding.rlReplyContainer.clickDebounce {
                when (neAttachmentMessage.type) {
                    MessageType.MESSAGE_TYPE_IMAGE -> {
                        neAttachmentMessage.attachment?.images?.let { listImage ->
                            val listUrl = listImage.map { it.url?.getUrlImage() ?: "" }
                            abstractClickListener.onDisplayImage(listUrl, 0, true, item.id)
                        }
                    }
                    MessageType.MESSAGE_TYPE_LOCATION -> {
                        neAttachmentMessage.attachment?.location?.let { neLocation ->
                            abstractClickListener.onLocationClick(neLocation, neAttachmentMessage)
                        }
                    }
                    MessageType.MESSAGE_TYPE_VIDEO -> {
                        neAttachmentMessage.attachment?.video?.let { neVideo ->
                            abstractClickListener.onViewVideo(neVideo, 0)
                        }
                    }
                    MessageType.MESSAGE_TYPE_FILE -> {
                        neAttachmentMessage.attachment?.file?.let { file ->
                            abstractClickListener.onDocumentAction(neAttachmentMessage.id, file, layoutPosition, false)
                        }
                    }
                    MessageType.MESSAGE_TYPE_AUDIO -> {
                        neAttachmentMessage.attachment?.audio?.let { neAudio ->
                            abstractClickListener.onAudioClick(messageId = item.id, relatedMessageId = neAttachmentMessage.id?.substringBefore("_"), audio = neAudio, itemClickedPos = layoutPosition)
                        }
                    }
                    else -> {
                        neAttachmentMessage.id?.let { messId -> abstractClickListener.onReplyClicked(messId) }
                    }
                }
            }
        }
        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgReplay)
        } else {
            themeHelperImpl.setThemeColorForViews(_binding.imgReplay)
        }
    }

    private fun showContentEmpty() {
        _binding.txtReplyContent.text = binding.root.resources.getString(R.string.message_reply_content_empty)
        _binding.txtReplyContent.isVisible = true
        _binding.rlPhotoReplyContent.isGone = true
        _binding.ivPlayVideo.isGone = true
    }
}
