package com.netacom.full.ui.main.chat.viewholder

import android.webkit.URLUtil
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.RowForwardMessageSenderBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MentionType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants.EMPTY
import com.netacom.lite.util.getUrlImage

class MessageForwardSenderViewHolder(
    val _binding: RowForwardMessageSenderBinding,
    private val contentClickListener: ItemClickListener?,
    private val abstractClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int,
    private val groupRepository: GroupRepository? = null
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?
    ) {

        _binding.item = item
        _binding.messagePosition = messagePosition

        // check event go to web or call
        AppUtils.setupSpannableString(
            view = _binding.textReply,
            type = MentionType.MINE,
            input = item.content ?: EMPTY,
            neMembers = members ?: emptyList(),
            callback = {
                contentClickListener?.onMentionClick(neMentionPosition = it)
            },
            themeColor = themeHelperImpl.mainColor,
            groupRepository = groupRepository
        )

        item.content?.let { textContent ->
            if (textContent.isNotNull && URLUtil.isValidUrl(textContent)) {
                _binding.newPreview.apply {
                    isVisible = true
                    load(textContent)
                }
            } else {
                _binding.newPreview.isGone = true
            }
        }

        // reply content
        item.attachment?.forwardMessage?.let { neAttachmentMessage ->
            when (neAttachmentMessage.type) {
                MessageType.MESSAGE_TYPE_TEXT -> {
                    AppUtils.setupSpannableString(
                        view = _binding.txtReplyContent,
                        type = MentionType.REPLY,
                        input = neAttachmentMessage.content ?: EMPTY,
                        neMembers = members ?: emptyList(),
                        callback = {
                            contentClickListener?.onMentionClick(neMentionPosition = it)
                        },
                        themeColor = themeHelperImpl.mainColor,
                        groupRepository = groupRepository
                    )
                    _binding.txtReplyContent.isVisible = true
                    _binding.rlPhotoReplyContent.isGone = true
                }
                MessageType.MESSAGE_TYPE_IMAGE -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true

                    val images = neAttachmentMessage.attachment?.images?.map {
                        it.url?.getUrlImage() ?: ""
                    } ?: emptyList()

                    when {
                        images.size == 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.isGone = true
                            _binding.vForwardBlur.isGone = true
                        }

                        images.size > 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.text =
                                String.format(binding.root.context.resources.getString(R.string.message_reply_image_count), images.size)
                            _binding.tvReplyPhotoCount.isVisible = true
                            _binding.vForwardBlur.isVisible = true
                        }

                        else -> {
                            showContentEmpty()
                        }
                    }
                }
                MessageType.MESSAGE_TYPE_VIDEO -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true
                    _binding.ivPlayVideo.isVisible = true

                    val thumbnailUrl = neAttachmentMessage.attachment?.video?.thumbnailUrl?.let {
                        it.getUrlImage()
                    }

                    if (!thumbnailUrl.isNullOrBlank()) {
                        _binding.ivReplyPhoto.loadImage(thumbnailUrl, corner = 1f)
                        _binding.tvReplyPhotoCount.isGone = true
                        _binding.vForwardBlur.isGone = true
                    } else {
                        showContentEmpty()
                    }
                }
                MessageType.MESSAGE_TYPE_FILE -> {
                    _binding.txtReplyContent.isVisible = true
                    _binding.rlPhotoReplyContent.isGone = true
                    _binding.ivPlayVideo.isGone = true

                    val fileName = neAttachmentMessage.attachment?.file?.name ?: ""
                    val fileExtension = neAttachmentMessage.attachment?.file?.extension ?: ""

                    if (fileName.isNotNull) {
                        _binding.txtReplyContent.text = if (fileExtension.isNotNull) fileName.plus(".$fileExtension") else fileName
                    } else {
                        showContentEmpty()
                    }
                }
                MessageType.MESSAGE_TYPE_LOCATION -> {
                    _binding.txtReplyContent.isGone = true
                    _binding.rlPhotoReplyContent.isVisible = true

                    val thumbnailUrl = neAttachmentMessage.attachment?.location?.image_url?.let {
                        it.getUrlImage()
                    }

                    if (!thumbnailUrl.isNullOrBlank()) {
                        _binding.ivReplyPhoto.loadImage(thumbnailUrl, corner = 1f)
                        _binding.tvReplyPhotoCount.isGone = true
                        _binding.vForwardBlur.isGone = true
                    } else {
                        showContentEmpty()
                    }
                }
                else -> {
                    showContentEmpty()
                }
            }

            _binding.rlReplyContainer.clickDebounce {
                when (neAttachmentMessage.type) {
                    MessageType.MESSAGE_TYPE_IMAGE -> {
                        neAttachmentMessage.attachment?.images?.let { listImage ->
                            val listUrl = listImage.map { it.url?.getUrlImage() ?: "" }
                            abstractClickListener.onDisplayImage(listUrl, 0, true, item.id)
                        }
                    }
                    MessageType.MESSAGE_TYPE_LOCATION -> {
                        neAttachmentMessage.attachment?.location?.let { neLocation ->
                            abstractClickListener.onLocationClick(neLocation, neAttachmentMessage)
                        }
                    }
                    MessageType.MESSAGE_TYPE_VIDEO -> {
                        neAttachmentMessage.attachment?.video?.let { neVideo ->
                            abstractClickListener.onViewVideo(neVideo, 0)
                        }
                    }
                    MessageType.MESSAGE_TYPE_FILE -> {
                        neAttachmentMessage.attachment?.file?.let { file ->
                            abstractClickListener.onDocumentAction(neAttachmentMessage.id, file, layoutPosition, false)
                        }
                    }
                    MessageType.MESSAGE_TYPE_AUDIO -> {
                        neAttachmentMessage.attachment?.audio?.let { neAudio ->
                            abstractClickListener.onAudioClick(messageId = item.id, relatedMessageId = neAttachmentMessage.id?.substringBefore("_"), audio = neAudio, itemClickedPos = layoutPosition)
                        }
                    }
                    else -> {
                        neAttachmentMessage.id?.let { messId -> abstractClickListener.onReplyClicked(messId) }
                    }
                }
            }
        }
        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgReplay, _binding.imgSend)
        } else {
            themeHelperImpl.setThemeColorForViews(_binding.imgReplay)
            if (item.status == MessageStatusType.MESSAGE_SEEN) {
                themeHelperImpl.setThemeColorForViews(_binding.imgSend)
            } else {
                _binding.imgSend.imageTintList = null
            }
        }
        themeHelperImpl.setThemeColorForMessage(_binding.textReply, ChatMessageType.MY_MESSAGE_FORWARD, groupType)
    }

    private fun showContentEmpty() {
        _binding.txtReplyContent.text = binding.root.resources.getString(R.string.message_reply_content_empty)
        _binding.txtReplyContent.isVisible = true
        _binding.rlPhotoReplyContent.isGone = true
        _binding.ivPlayVideo.isGone = true
    }
}
