package com.netacom.full.ui.main.chat.viewholder

import android.content.Context
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.GridLayoutManager
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.ApiResponseError
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.util.isLocalLink
import com.netacom.full.databinding.RowMessageImageRecevierBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.chat.adapter.PhotoMessageAdapter
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.ui.message.NeImage
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.util.FileUtils
import com.netacom.lite.util.getUrlImage
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class MessageImageReceiverViewHolder(
    val _binding: RowMessageImageRecevierBinding,
    val context: Context,
    private val downloadRepository: DownloadRepository,
    private val contentClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int,
) : BaseViewHolder<ViewDataBinding>(_binding) {
    private var actionLongClick: ItemClickListener? = null
    private var currentItem: NeMessage? = null
    fun bind(
        message: NeMessage?,
        members: List<NeUser>,
        messagePosition: MessagePosition,
        isSingle: Boolean,
        avatarCallback: () -> Unit
    ) {
        message?.let { item ->
            currentItem = item
            _binding.item = item
            _binding.messagePosition = messagePosition
            _binding.receiverColor = themeHelperImpl.mainColor
            _binding.isSingle = isSingle

            // check list image is path(local path) or mediaUid(server id)
            item.attachment?.images?.forEach { neImage ->
                neImage.sub_index = neImage.sub_index ?: neImage.index
                if (neImage.url?.isLocalLink() == false) {
                    neImage.url = neImage.url?.getUrlImage()
                }
            }

            _binding.ivAvatarReceiver.clickDebounce {
                avatarCallback()
            }

            showImageMessageData(item.attachment?.images ?: emptyList(), neMessage = message)
        }
    }

    private fun showImageMessageData(lstData: List<NeImage>, neMessage: NeMessage) {
        if (lstData.isEmpty()) return
        val isSingleFile = lstData.size <= 1
        if (isSingleFile) {
            _binding.recyclerView.isGone = true
            _binding.ivPhoto.isVisible = true
        } else {
            _binding.recyclerView.isVisible = true
            _binding.ivPhoto.isGone = true
        }

        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            lstData.forEachIndexed { index, neImage ->
                neImage.isLoading = true
                val uid = neImage.url?.split("/")?.last()
                val localImageSecretPath = "${FileUtils.secretFolderPath}/${neMessage.id}/$uid"
                if (com.netacom.base.chat.android_utils.FileUtils.isFileExists(localImageSecretPath)) {
                    neImage.isLoading = false
                    lstData[index].url = localImageSecretPath
                    if (isSingleFile) {
                        loadSinglePhoto(lstData[0], neMessage)
                    } else {
                        loadListPhotos(lstData, neMessage)
                    }
                } else {
                    CoroutineScope(Dispatchers.IO).launch {
                        downloadRepository.downloadFiles(arrayListOf(neImage.url)).collect {
                            when (it) {
                                is ApiResponseSuccess -> {
                                    val responseDownload = it.data
                                    responseDownload?.let { responseBody ->
                                        uid?.let { it1 ->
                                            FileUtils.saveEncryptedFileToLocal(
                                                body = responseBody,
                                                path = "${FileUtils.secretFolderPath}/${neMessage.id}",
                                                it1
                                            ).let { path ->
                                                neImage.isLoading = false
                                                lstData[index].url = path
                                                withContext(Dispatchers.Main) {
                                                    if (isSingleFile) {
                                                        loadSinglePhoto(lstData[0], neMessage)
                                                    } else {
                                                        loadListPhotos(lstData, neMessage)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                is ApiResponseError -> {
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (isSingleFile) {
                loadSinglePhoto(lstData[0], neMessage)
            } else {
                loadListPhotos(lstData, neMessage)
            }
        }
    }

    private fun loadSinglePhoto(neImage: NeImage, neMessage: NeMessage) {
        if (neImage.isLoading) {
            _binding.progressBar.isVisible = true
        } else {
            _binding.progressBar.isGone = true
            _binding.ivPhoto.loadImage(neImage.url, neImage.width ?: 720, neImage.height ?: 960)
            _binding.ivPhoto.clickDebounce {
                Logger.d("ItemClicked: $position - UID: ${neImage.url}")
                neImage.url?.let {
                    contentClickListener.onDisplayImage(mutableListOf(it), 0, messageId = neMessage.id)
                }
            }
        }
    }

    private fun loadListPhotos(lstData: List<NeImage>, neMessage: NeMessage) {
        with(_binding.recyclerView) {
            val column: Int
            layoutManager = if (lstData.size > 2) {
                column = 3
                GridLayoutManager(context, 3)
            } else {
                column = 2
                GridLayoutManager(context, 2)
            }

            adapter = PhotoMessageAdapter(
                context = context,
                message = neMessage,
                column = column,
                imageClick = { pos, neImage ->
                    Logger.d("ItemClicked: pos = $pos, url = ${neImage.url}")
                    val listUrl = lstData.mapNotNull { data -> data.url }
                    contentClickListener.onDisplayImage(listUrl, pos, messageId = neMessage.id)
                },
                imageLongClick = {
                    currentItem?.let { message ->
                        actionLongClick?.onLongItemClick(message)
                    }
                }
            )
        }
        updateListPhoto(lstData)
    }

    private fun updateListPhoto(lstData: List<NeImage>) {
        (_binding.recyclerView.adapter as? PhotoMessageAdapter)?.display(lstData)
    }

    fun setItemLongClickAction(clickListener: ItemClickListener) {
        actionLongClick = clickListener
    }
}
