package com.netacom.full.ui.main.chat.viewholder

import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.GridLayoutManager
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isLocalLink
import com.netacom.base.chat.util.isNull
import com.netacom.full.databinding.RowMessageImageSenderBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.chat.adapter.PhotoMessageAdapter
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeImage
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.util.getUrlImage
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class MessageImageSenderViewHolder(
    val _binding: RowMessageImageSenderBinding,
    private val contentClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {
    private var actionLongClick: ItemClickListener? = null
    private var currentItem: NeMessage? = null
    fun bind(
        message: NeMessage?,
        messagePosition: MessagePosition
    ) {
        message?.let { item ->
            currentItem = item
            // binding to layout
            _binding.item = item
            _binding.messagePosition = messagePosition

            // check list image is path(local path) or mediaUid(server id)
            item.attachment?.images?.forEach { neImage ->
                neImage.sub_index = neImage.sub_index ?: neImage.index
                neImage.isLoading = item.status == MessageStatusType.MESSAGE_SENDING
                if (neImage.url?.isLocalLink() == false) {
                    neImage.url = neImage.url?.getUrlImage()
                }
            }

            showImageMessageData(item)
            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend)
            } else {
                if (item.status == MessageStatusType.MESSAGE_SEEN) {
                    themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                } else {
                    _binding.imgSend.imageTintList = null
                }
            }
        }
    }

    private fun showImageMessageData(neMessage: NeMessage) {
        val lstData = neMessage.attachment?.images ?: emptyList()
        if (lstData.isNull) return
        val isSingleFile = lstData.size <= 1
        if (isSingleFile) {
            _binding.recyclerView.isGone = true
            _binding.ivPhoto.isVisible = true
        } else {
            _binding.recyclerView.isVisible = true
            _binding.ivPhoto.isGone = true
        }

        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            CoroutineScope(Dispatchers.IO).launch {
                lstData.forEach { neImage ->
                    val uid = if (neImage.url?.contains("https://", true) == true) neImage.url?.split("/")?.last() else null
                    val localImageSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMessage.id}"
                    if (uid != null) {
                        if (FileUtils.isFileExists("$localImageSecretPath/${neImage.index}")) {
                            FileUtils.rename("$localImageSecretPath/${neImage.index}", uid)
                        }
                        lstData[neImage.index].url = "$localImageSecretPath/$uid"
                    } else {
                        if (FileUtils.isFileExists("$localImageSecretPath/${neImage.index}")) {
                            lstData[neImage.index].url = "$localImageSecretPath/${neImage.index}"
                        }
                    }
                }
                withContext(Dispatchers.Main) {
                    if (isSingleFile) {
                        loadSinglePhoto(lstData[0], neMessage = neMessage)
                    } else {
                        loadListPhotos(lstData, neMessage)
                    }
                }
            }
        } else {
            if (isSingleFile) {
                loadSinglePhoto(lstData[0], neMessage = neMessage)
            } else {
                loadListPhotos(lstData, neMessage)
            }
        }
    }

    private fun loadSinglePhoto(neImage: NeImage, neMessage: NeMessage) {
        _binding.ivPhoto.loadImage(neImage.url, neImage.width ?: 720, neImage.height ?: 960)
        _binding.ivPhoto.clickDebounce {
            Logger.d("ItemClicked: $position - UID: ${neImage.url}")
            neImage.url?.let {
                contentClickListener.onDisplayImage(mutableListOf(it), 0, messageId = neMessage.id)
            }
        }
    }

    private fun loadListPhotos(lstData: List<NeImage>, neMessage: NeMessage) {
        Logger.e("loadListPhotos==$lstData")
        with(_binding.recyclerView) {
            val column: Int
            layoutManager = if (lstData.size > 2) {
                column = 3
                GridLayoutManager(context, 3)
            } else {
                column = 2
                GridLayoutManager(context, 2)
            }

            adapter = PhotoMessageAdapter(
                context = context,
                message = neMessage,
                column = column,
                imageClick = { pos, neImage ->
                    Logger.d("ItemClicked: pos = $pos, url = ${neImage.url}")
                    val listUrl = lstData.mapNotNull { data -> data.url }
                    contentClickListener.onDisplayImage(listUrl, pos, messageId = neMessage.id)
                },
                imageLongClick = {
                    currentItem?.let { message ->
                        if (message.status != MessageStatusType.MESSAGE_SENDING && message.status != MessageStatusType.MESSAGE_FAILED) {
                            actionLongClick?.onLongItemClick(message)
                        }
                    }
                }
            )
            (adapter as? PhotoMessageAdapter)?.display(lstData)
        }
    }

    fun setItemLongClickAction(clickListener: ItemClickListener) {
        actionLongClick = clickListener
    }
}
