package com.netacom.full.ui.main.chat.viewholder

import android.content.Context
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.SizeUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.databinding.RowMessageImageRecevierBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.getUrlImage

class MessageLocationReceiverViewHolder(
    val _binding: RowMessageImageRecevierBinding,
    val context: Context,
    private val contentClickListener: AbstractItemClickListener,
) : BaseViewHolder<ViewDataBinding>(_binding) {
    fun bind(
        message: NeMessage?,
        members: List<NeUser>,
        messagePosition: MessagePosition,
        isSingle: Boolean,
        avatarCallback: () -> Unit
    ) {
        message?.let { _message ->
            _binding.item = _message
            _message.attachment?.location?.image_url?.let { url ->
                val isTemp = url.run {
                    this.split("/").size > 2
                }
                val urlImage = if (isTemp) {
                    url
                } else {
                    url.getUrlImage()
                }
                _binding.ivPhoto.layoutParams.let { layoutParam ->
                    layoutParam.width = SizeUtils.dp2px(200f)
                    layoutParam.height = SizeUtils.dp2px(130f)
                }
                _binding.ivPhoto.loadImage(urlImage)
            }
            _binding.ivPhoto.clickDebounce {
                _message.attachment?.location?.let { neLocation ->
                    contentClickListener.onLocationClick(neLocation = neLocation, message)
                }
            }
        }
    }
}
