package com.netacom.full.ui.main.chat.viewholder

import android.content.Context
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.SizeUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.databinding.RowMessageImageSenderBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.getUrlImage

class MessageLocationSenderViewHolder(
    private val context: Context,
    val _binding: RowMessageImageSenderBinding,
    private val contentClickListener: AbstractItemClickListener,
    private val groupRepository: GroupRepository,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int
) : BaseViewHolder<ViewDataBinding>(_binding) {
    fun bind(
        message: NeMessage?,
        messagePosition: MessagePosition
    ) {
        message?.let { _message ->
            _binding.item = _message

            _message.attachment?.location?.image_url?.let { url ->
                val isTemp = url.run {
                    this.split("/").size > 2
                }
                val urlImage = if (isTemp) {
                    url
                } else {
                    url.getUrlImage()
                }
                _binding.ivPhoto.layoutParams.let { layoutParam ->
                    layoutParam.width = SizeUtils.dp2px(200f)
                    layoutParam.height = SizeUtils.dp2px(130f)
                }
                _binding.ivPhoto.loadImage(urlImage)
            }
            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend)
            } else {
                if (_message.status == MessageStatusType.MESSAGE_SEEN) {
                    themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                } else {
                    _binding.imgSend.imageTintList = null
                }
            }
            _binding.ivPhoto.clickDebounce {
                _message.attachment?.location?.let { neLocation ->
                    contentClickListener.onLocationClick(neLocation = neLocation, message)
                }
            }
        }
    }
}
