package com.netacom.full.ui.main.chat.viewholder

import android.view.View
import android.webkit.URLUtil
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.isLocalLink
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.RowReplyMessageSenderBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MentionType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants
import com.netacom.lite.util.Constants.EMPTY
import com.netacom.lite.util.getUrlImage

class MessageReplySenderViewHolder(
    val _binding: RowReplyMessageSenderBinding,
    private val contentClickListener: ItemClickListener?,
    private val abstractClickListener: AbstractItemClickListener,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int,
    private val groupRepository: GroupRepository? = null
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?
    ) {
        _binding.item = item
        _binding.messagePosition = messagePosition

        AppUtils.setupSpannableString(
            view = _binding.textReply,
            type = MentionType.MINE,
            input = item.content ?: EMPTY,
            neMembers = members ?: emptyList(),
            callback = {
                contentClickListener?.onMentionClick(neMentionPosition = it)
            },
            themeColor = themeHelperImpl.mainColor,
            groupRepository = groupRepository
        )

        item.content?.let { textContent ->
            if (textContent.isNotNull && URLUtil.isValidUrl(textContent)) {
                _binding.newPreview.apply {
                    isVisible = true
                    load(textContent)
                }
            } else {
                _binding.newPreview.isGone = true
            }
        }

        // reply content
        item.attachment?.replyMessage?.let { neAttachmentMessage ->
            when (neAttachmentMessage.type) {
                MessageType.MESSAGE_TYPE_TEXT -> {
                    AppUtils.setupSpannableString(
                        view = _binding.txtReplyContent,
                        type = MentionType.REPLY,
                        input = neAttachmentMessage.content ?: EMPTY,
                        neMembers = members ?: emptyList(),
                        callback = {
                            contentClickListener?.onMentionClick(neMentionPosition = it)
                        },
                        themeColor = themeHelperImpl.mainColor,
                        groupRepository = groupRepository
                    )
                    _binding.txtReplyContent.visibility = View.VISIBLE
                    _binding.rlPhotoReplyContent.visibility = View.GONE
                }
                MessageType.MESSAGE_TYPE_IMAGE -> {
                    _binding.txtReplyContent.visibility = View.GONE
                    _binding.rlPhotoReplyContent.visibility = View.VISIBLE

                    val images = if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                        val localImageSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neAttachmentMessage.id?.split("_")?.first()}"
                        neAttachmentMessage.attachment?.images?.map {
                            when {
                                it.url?.isLocalLink() == true -> {
                                    it.url
                                }
                                FileUtils.isFileExists("$localImageSecretPath/${it.url}") -> {
                                    "$localImageSecretPath/${it.url}"
                                }
                                else -> {
                                    it.url?.getUrlImage() ?: ""
                                }
                            }
                        } ?: emptyList()
                    } else {
                        neAttachmentMessage.attachment?.images?.map {
                            it.url?.getUrlImage() ?: ""
                        } ?: emptyList()
                    }

                    when {
                        images.size == 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.visibility = View.GONE
                            _binding.vReplyBlur.visibility = View.GONE
                        }

                        images.size > 1 -> {
                            _binding.ivReplyPhoto.loadImage(images[0], corner = 1f)
                            _binding.tvReplyPhotoCount.text =
                                String.format(_binding.root.context.resources.getString(R.string.message_reply_image_count), images.size)
                            _binding.tvReplyPhotoCount.visibility = View.VISIBLE
                            _binding.vReplyBlur.visibility = View.VISIBLE
                        }

                        else -> {
                            showReplyEmpty()
                        }
                    }
                }
                MessageType.MESSAGE_TYPE_VIDEO -> {
                    _binding.txtReplyContent.visibility = View.GONE
                    _binding.rlPhotoReplyContent.visibility = View.VISIBLE
                    neAttachmentMessage.attachment?.video?.url?.let {
                        val videoSecretPath: String? = if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                            val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neAttachmentMessage.id?.split("_")?.first()}"
                            when {
                                FileUtils.isFileExists("$localVideoSecretPath/${Constants.VIDEO_THUMBNAIL}") -> {
                                    "$localVideoSecretPath/${Constants.VIDEO_THUMBNAIL}"
                                }
                                FileUtils.isFileExists("$localVideoSecretPath/0") -> {
                                    "$localVideoSecretPath/0"
                                }
                                else -> {
                                    neAttachmentMessage.attachment?.video?.thumbnailUrl.getUrlImage() ?: it.getUrlImage()
                                }
                            }
                        } else {
                            neAttachmentMessage.attachment?.video?.thumbnailUrl.getUrlImage() ?: it.getUrlImage()
                        }
                        _binding.ivReplyPhoto.loadImage(videoSecretPath, corner = 1f)
                        _binding.vReplyBlur.visibility = View.GONE
                        _binding.tvReplyPhotoCount.isGone = true
                        _binding.ivVidPlay.isVisible = true
                    } ?: kotlin.run {
                        showReplyEmpty()
                    }
                }
                MessageType.MESSAGE_TYPE_AUDIO -> {
                    _binding.txtReplyContent.visibility = View.VISIBLE
                    _binding.rlPhotoReplyContent.visibility = View.GONE
                    neAttachmentMessage.attachment?.audio?.url?.let {
                        _binding.txtReplyContent.text = _binding.root.context.resources.getString(R.string.last_message_audio)
                    } ?: kotlin.run {
                        _binding.txtReplyContent.text = _binding.root.context.resources.getString(R.string.message_reply_content_empty)
                    }
                }
                MessageType.MESSAGE_TYPE_FILE -> {
                    _binding.txtReplyContent.visibility = View.VISIBLE
                    _binding.rlPhotoReplyContent.visibility = View.GONE
                    neAttachmentMessage.attachment?.file?.name?.let {
                        _binding.txtReplyContent.text = it
                        _binding.txtReplyContent.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_reply_file_attacthment, 0)
                    } ?: kotlin.run {
                        _binding.txtReplyContent.text = _binding.root.context.resources.getString(R.string.message_reply_content_empty)
                    }
                }
                MessageType.MESSAGE_TYPE_STICKER -> {
                    _binding.txtReplyContent.visibility = View.GONE
                    _binding.rlPhotoReplyContent.visibility = View.VISIBLE
                    _binding.ivReplyPhoto.loadImage(neAttachmentMessage.attachment?.stickerUrl, R.drawable.ic_default_sticker)
                    _binding.tvReplyPhotoCount.visibility = View.GONE
                    _binding.vReplyBlur.visibility = View.GONE
                }
                else -> {
                    showReplyEmpty()
                }
            }

            _binding.rlReplyContainer.clickDebounce {
                when (neAttachmentMessage.type) {
                    MessageType.MESSAGE_TYPE_IMAGE -> {
                        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                            val localImageSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neAttachmentMessage.id?.split("_")?.first()}"
                            neAttachmentMessage.attachment?.images?.let { listImage ->
                                val listUrl = listImage.map {
                                    val localImage = "$localImageSecretPath/${it.url}"
                                    if (FileUtils.isFileExists(localImage)) {
                                        localImage
                                    } else {
                                        it.url?.getUrlImage() ?: ""
                                    }
                                }
                                abstractClickListener.onDisplayImage(listUrl, 0, true, item.id)
                            }
                        } else {
                            neAttachmentMessage.attachment?.images?.let { listImage ->
                                val listUrl = listImage.map { it.url?.getUrlImage() ?: "" }
                                abstractClickListener.onDisplayImage(listUrl, 0, true, item.id)
                            }
                        }
                    }
                    MessageType.MESSAGE_TYPE_VIDEO -> {
                        neAttachmentMessage.attachment?.video?.let { neVideo ->
                            abstractClickListener.onViewVideo(neVideo, 0)
                        }
                    }
                    MessageType.MESSAGE_TYPE_FILE -> {
                        neAttachmentMessage.attachment?.file?.let { file ->
                            abstractClickListener.onDocumentAction(neAttachmentMessage.id, file, layoutPosition, false)
                        }
                    }
                    MessageType.MESSAGE_TYPE_AUDIO -> {
                        neAttachmentMessage.attachment?.audio?.let { neAudio ->
                            abstractClickListener.onAudioClick(messageId = item.id, relatedMessageId = neAttachmentMessage.id?.substringBefore("_"), audio = neAudio, itemClickedPos = layoutPosition)
                        }
                    }
                    else -> {
                        neAttachmentMessage.id?.let { messId -> abstractClickListener.onReplyClicked(messId) }
                    }
                }
            }
        }
        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgReplay, _binding.imgSend)
        } else {
            themeHelperImpl.setThemeColorForViews(_binding.imgReplay)
            if (item.status == MessageStatusType.MESSAGE_SEEN) {
                themeHelperImpl.setThemeColorForViews(_binding.imgSend)
            } else {
                _binding.imgSend.imageTintList = null
            }
        }
        themeHelperImpl.setThemeColorForMessage(_binding.textReply, ChatMessageType.MY_MESSAGE_REPLY, groupType)
    }

    private fun showReplyEmpty() {
        _binding.txtReplyContent.text = _binding.root.context.resources.getString(R.string.message_reply_content_empty)
        _binding.txtReplyContent.visibility = View.VISIBLE
        _binding.rlPhotoReplyContent.visibility = View.GONE
    }
}
