package com.netacom.full.ui.main.chat.viewholder

import android.view.View
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.base.chat.util.isNull
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageStickerReceiverBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.local.db.DbManager
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.repository.StickerRepository

class MessageStickerReceiverViewHolder(
    val _binding: RowMessageStickerReceiverBinding,
    private val themeHelperImpl: ThemeHelperImpl,
    private val downloadRepository: DownloadRepository,
    private val stickerRepository: StickerRepository,
    private val dbManager: DbManager,
    private val contentClickListener: AbstractItemClickListener
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        avatarCallback: () -> Unit,
        isSingle: Boolean
    ) {
        _binding.item = item
        _binding.messagePosition = messagePosition
        _binding.receiverColor = themeHelperImpl.mainColor

        _binding.ivSticker.setOnLongClickListener {
            contentClickListener.onLongItemClick(item)
            false
        }

        _binding.ivSticker.clickDebounce {
            avatarCallback()
        }
        if (item.attachment?.stickerUrl.isNull) {
            stickerRepository.getMoreStickersFromServer(
                downloadRepository,
                callbackSuccess = {
                    item.attachment?.stickerId?.let { stickerId ->
                        dbManager.getStickerById(stickerId)?.let { dbSticker ->
                            _binding.ivSticker.loadImage(dbSticker.filePath, R.drawable.ic_default_sticker)
                        }
                    }
                }
            )
            item.attachment?.stickerId?.let {
                if (dbManager.getStickerById(it) == null) {
                    stickerRepository.stickerAvailable.observeForever { status ->
                        if (status != null && status == true) {
                            item.attachment?.stickerId?.let { stickerId ->
                                dbManager.getStickerById(stickerId)?.let { dbSticker ->
                                    _binding.ivSticker.loadImage(dbSticker.filePath, R.drawable.ic_default_sticker)
                                    item.attachment?.stickerUrl = dbSticker.filePath
                                }
                            }
                        }
                    }
                }
            }
        } else {
            _binding.ivSticker.loadImage(item.attachment?.stickerUrl, R.drawable.ic_default_sticker)
        }

        _binding.tvReceiverTime.text = DateTimeUtils.ParseDateTimeToString.parseJustTime(DateTimeUtils.getMillisFromNano(item.createAt))
        _binding.isSingle = isSingle
        when (messagePosition) {
            MessagePosition.SINGLE -> {
                _binding.vSeparator.visibility = View.VISIBLE
                _binding.tvReceiverTime.visibility = View.VISIBLE
            }
            MessagePosition.TOP -> {
                _binding.vSeparator.visibility = View.VISIBLE
                _binding.tvReceiverTime.visibility = View.GONE
            }
            MessagePosition.MID -> {
                _binding.vSeparator.visibility = View.GONE
                _binding.tvReceiverTime.visibility = View.GONE
            }
            MessagePosition.BOTTOM -> {
                _binding.vSeparator.visibility = View.GONE
                _binding.tvReceiverTime.visibility = View.VISIBLE
            }
        }
    }
}
