package com.netacom.full.ui.main.chat.viewholder

import android.view.View
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.base.chat.util.isNull
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageStickerSenderBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.local.db.DbManager
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.repository.StickerRepository

class MessageStickerSenderViewHolder(
    val _binding: RowMessageStickerSenderBinding,
    val themeHelperImpl: ThemeHelperImpl,
    val groupType: Int,
    private val downloadRepository: DownloadRepository,
    private val stickerRepository: StickerRepository,
    private val dbManager: DbManager,
    private val contentClickListener: AbstractItemClickListener
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition
    ) {
        _binding.item = item
        _binding.messagePosition = messagePosition
        _binding.ivSticker.setOnLongClickListener {
            if (item.status != MessageStatusType.MESSAGE_SENDING && item.status != MessageStatusType.MESSAGE_FAILED) {
                contentClickListener.onLongItemClick(item)
            }
            false
        }
        if (item.attachment?.stickerUrl.isNull) {
            stickerRepository.getMoreStickersFromServer(
                downloadRepository,
                callbackSuccess = {
                    item.attachment?.stickerId?.let { stickerId ->
                        dbManager.getStickerById(stickerId)?.let { dbSticker ->
                            _binding.ivSticker.loadImage(dbSticker.filePath, R.drawable.ic_default_sticker)
                        }
                    }
                }
            )
            item.attachment?.stickerId?.let {
                if (dbManager.getStickerById(it) == null) {
                    stickerRepository.stickerAvailable.observeForever { status ->
                        if (status != null && status == true) {
                            item.attachment?.stickerId?.let { stickerId ->
                                dbManager.getStickerById(stickerId)?.let { dbSticker ->
                                    _binding.ivSticker.loadImage(dbSticker.filePath, R.drawable.ic_default_sticker)
                                    item.attachment?.stickerUrl = dbSticker.filePath
                                }
                            }
                        }
                    }
                }
            }
        } else {
            _binding.ivSticker.loadImage(item.attachment?.stickerUrl, R.drawable.ic_default_sticker)
        }
        _binding.tvSenderTime.text = DateTimeUtils.ParseDateTimeToString.parseJustTime(DateTimeUtils.getMillisFromNano(item.createAt))

        when (messagePosition) {
            MessagePosition.SINGLE -> {
                _binding.vSeparator.visibility = View.VISIBLE
                _binding.tvSenderTime.visibility = View.VISIBLE
            }
            MessagePosition.TOP -> {
                _binding.vSeparator.visibility = View.VISIBLE
                _binding.tvSenderTime.visibility = View.GONE
            }
            MessagePosition.MID -> {
                _binding.vSeparator.visibility = View.GONE
                _binding.tvSenderTime.visibility = View.GONE
            }
            MessagePosition.BOTTOM -> {
                _binding.vSeparator.visibility = View.GONE
                _binding.tvSenderTime.visibility = View.VISIBLE
            }
        }

        showMessageStatus(item = item, _binding = _binding)
    }

    private fun showMessageStatus(item: NeMessage, _binding: RowMessageStickerSenderBinding) {
        when (item.status) {
            MessageStatusType.MESSAGE_SENDING -> {
                _binding.imgSend.setImageResource(R.drawable.ic_vector_loading)
            }
            MessageStatusType.MESSAGE_SENT -> {
                _binding.imgSend.setImageResource(R.drawable.ic_single_check)
            }
            MessageStatusType.MESSAGE_SEEN, MessageStatusType.MESSAGE_RECEIVED -> {
                _binding.imgSend.setImageResource(R.drawable.ic_double_check)
            }
            MessageStatusType.MESSAGE_FAILED -> {
                _binding.imgSend.setImageResource(R.drawable.ic_sent_fail)
            }
        }
        if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
            themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend)
        } else {
            if (item.status == MessageStatusType.MESSAGE_SEEN) {
                themeHelperImpl.setThemeColorForViews(_binding.imgSend)
            } else {
                _binding.imgSend.imageTintList = null
            }
        }
    }
}
