package com.netacom.full.ui.main.chat.viewholder

import android.content.Context
import android.webkit.URLUtil
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageReceiverBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.MentionType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants

class MessageTextReceiverViewHolder(
    val _binding: RowMessageReceiverBinding,
    private val contentClickListener: ItemClickListener?,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupRepository: GroupRepository? = null
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?,
        avatarCallback: () -> Unit,
        isSingle: Boolean,
        context: Context? = null
    ) {
        _binding.ivAvatarReceiver.setImageDrawable(null)
        _binding.item = item
        _binding.messagePosition = messagePosition
        _binding.isSingle = isSingle
        _binding.receiverColor = themeHelperImpl.mainColor
        if (item.status != MessageStatusType.MESSAGE_DELETED) {
//            val content: String = item.type?.let { type ->
//                if (type == MessageType.MESSAGE_TYPE_SCREENSHOT) {
//                    context?.let { ctx ->
//                        String.format(ctx.resources.getString(R.string.message_capture_screenshot), item.owner?.getDisplayName ?: ctx.resources.getString(R.string.unknown_user))
//                    } ?: Constants.EMPTY
//                } else Constants.EMPTY
//            } ?: Constants.EMPTY

            AppUtils.setupSpannableString(
                view = _binding.txtTitle,
                type = MentionType.PARTNER,
                input = item.content ?: Constants.EMPTY,
                neMembers = members ?: emptyList(),
                callback = {
                    contentClickListener?.onMentionClick(neMentionPosition = it)
                },
                themeColor = themeHelperImpl.mainColor,
                groupRepository = groupRepository
            )
            _binding.txtTitle.setBackgroundResource(R.drawable.bg_single_receiver)

            item.content?.let { textContent ->
                if (textContent.isNotNull && URLUtil.isValidUrl(textContent)) {
                    _binding.newPreview.apply {
                        isVisible = true
                        load(textContent)
                    }
                } else {
                    _binding.newPreview.isGone = true
                }
            }
        }
        _binding.ivAvatarReceiver.clickDebounce {
            avatarCallback()
        }
    }
}
