package com.netacom.full.ui.main.chat.viewholder

import android.content.Context
import android.webkit.URLUtil
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.databinding.RowMessageSenderBinding
import com.netacom.full.define.ChatMessageType
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.ItemClickListener
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MentionType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants

class MessageTextSenderViewHolder(
    val _binding: RowMessageSenderBinding,
    private val contentClickListener: ItemClickListener?,
    private val themeHelperImpl: ThemeHelperImpl,
    private val groupType: Int,
    private val groupRepository: GroupRepository? = null
) : BaseViewHolder<ViewDataBinding>(_binding) {

    fun bind(
        item: NeMessage,
        messagePosition: MessagePosition,
        members: List<NeUser>?,
        context: Context? = null
    ) {
        _binding.item = item
        _binding.messagePosition = messagePosition

        if (item.status != MessageStatusType.MESSAGE_DELETED) {
//            val content: String = item.type?.let { type ->
//                if (type == MessageType.MESSAGE_TYPE_SCREENSHOT) {
//                    context?.resources?.getString(R.string.me_message_capture_screenshot) ?: Constants.EMPTY
//                } else Constants.EMPTY
//            } ?: Constants.EMPTY

            AppUtils.setupSpannableString(
                view = _binding.txtTitle,
                type = MentionType.MINE,
                input = item.content ?: Constants.EMPTY,
                neMembers = members ?: emptyList(),
                callback = {
                    // contentClickListener?.onMentionClick(neMentionPosition = it)
                },
                themeColor = themeHelperImpl.mainColor,
                groupRepository = groupRepository
            )
            themeHelperImpl.setThemeColorForMessage(_binding.txtTitle, ChatMessageType.MY_MESSAGE_TEXT, groupType)
            if (groupType == GroupType.GROUP_TYPE_PRIVATE) {
                themeHelperImpl.setThemeColorForSecretChat(_binding.imgSend)
            } else {
                if (item.status == MessageStatusType.MESSAGE_SEEN) {
                    themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                } else {
                    _binding.imgSend.imageTintList = null
                }
            }
            item.content?.let { textContent ->
                if (textContent.isNotNull && URLUtil.isValidUrl(textContent)) {
                    _binding.newPreview.apply {
                        isVisible = true
                        load(textContent)
                    }
                } else {
                    _binding.newPreview.isGone = true
                }
            }
        }
    }
}
