package com.netacom.full.ui.main.chat.viewholder

import android.annotation.SuppressLint
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.util.DateTimeUtils
import com.netacom.full.R
import com.netacom.full.databinding.ItemChatTimeBinding

/**
 * Create on 5/21/20
 * @author duonghd
 */

class MessageTextTimeViewHolder(binding: ItemChatTimeBinding) : BaseViewHolder<ViewDataBinding>(binding) {

    @SuppressLint("SimpleDateFormat")
    fun bind(time: Long) {
        binding as ItemChatTimeBinding

        binding.txtTime.text = DateTimeUtils.ParseDateTimeToString.parse(
            time.run {
                if (time.toString().length > 10) {
                    time.toString().substring(0, 10).toLong() * 1000
                } else {
                    time * 1000
                }
            },
            DateTimeUtils.ParseDateTimeToString.FULL_DATE_TIME_FORMAT_PATTERN
        )
    }

    companion object {

        @JvmStatic
        fun create(parent: ViewGroup): MessageTextTimeViewHolder {
            val binding = DataBindingUtil.inflate<ItemChatTimeBinding>(
                LayoutInflater.from(parent.context),
                R.layout.item_chat_time,
                parent,
                false
            )
            return MessageTextTimeViewHolder(binding)
        }
    }
}
