package com.netacom.full.ui.main.chat.viewholder

import android.os.CountDownTimer
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import com.google.android.exoplayer2.ExoPlaybackException
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.ConvertUtils
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.android_utils.TimeUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.ApiResponseError
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.util.isLocalLink
import com.netacom.base.chat.util.isNull
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageVideoReceiverBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.widget.video.IPlayerClickListener
import com.netacom.full.widget.video.IPlayerStateListener
import com.netacom.full.widget.video.PlayerExoHelper
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.util.Constants
import com.netacom.lite.util.getUrlImage
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class MessageVideoReceiverViewHolder(
    val _binding: RowMessageVideoReceiverBinding,
    private val contentClickListener: AbstractItemClickListener?,
    private val themeHelperImpl: ThemeHelperImpl,
    private val token: String,
    private val groupType: Int,
    private val downloadRepository: DownloadRepository,
    private val playerExoHelper: PlayerExoHelper,
) : BaseViewHolder<ViewDataBinding>(_binding) {

    private var isMute: Boolean = true
    private var isInitialize: Boolean = false

    private val dp130 = ConvertUtils.dp2px(150f)
    private val dp200 = ConvertUtils.dp2px(265f)

    fun bind(
        item: NeMessage,
        position: MessagePosition,
        members: List<NeUser>,
        isSingle: Boolean,
        avatarCallback: () -> Unit
    ) {
        with(_binding) {
            this.item = item
            messagePosition = position
            this.isSingle = isSingle
            ivAvatarReceiver.clickDebounce {
                avatarCallback()
            }
            receiverColor = themeHelperImpl.mainColor
            item.attachment?.video?.let {
                if (it.width > it.height) {
                    ivThumbnail.layoutParams.width = dp200
                    ivThumbnail.layoutParams.height = dp130

                    videoPlayer.layoutParams.width = dp200
                    videoPlayer.layoutParams.height = dp130
                } else {
                    ivThumbnail.layoutParams.width = dp130
                    ivThumbnail.layoutParams.height = dp200

                    videoPlayer.layoutParams.width = dp130
                    videoPlayer.layoutParams.height = dp200
                }
                if (it.url?.isLocalLink() == true) {
                    ivThumbnail.loadImage(it.url)
                } else {
                    if (isEncrypt()) {
                        val localThumbnailSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}/${Constants.VIDEO_THUMBNAIL}"
                        val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}/0"
                        if (FileUtils.isFileExists(localThumbnailSecretPath)) {
                            ivThumbnail.loadImage(localThumbnailSecretPath)
                        } else {
                            pbVidLoading.isVisible = true
                            CoroutineScope(Dispatchers.IO).launch {
                                downloadRepository.downloadFiles(arrayListOf(it.thumbnailUrl?.getUrlImage())).collect { response ->
                                    when (response) {
                                        is ApiResponseSuccess -> {
                                            val responseDownload = response.data
                                            responseDownload?.let { responseBody ->
                                                com.netacom.lite.util.FileUtils.saveEncryptedFileToLocal(
                                                    body = responseBody,
                                                    path = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}",
                                                    fileName = Constants.VIDEO_THUMBNAIL
                                                ).let { localThumbnailSecretPath ->
                                                    withContext(Dispatchers.Main) {
                                                        pbVidLoading.isVisible = false
                                                        if (FileUtils.isFileExists(localThumbnailSecretPath)) {
                                                            ivThumbnail.loadImage(localThumbnailSecretPath)
                                                        } else {
                                                            ivThumbnail.loadImage(localVideoSecretPath)
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        is ApiResponseError -> {
                                            withContext(Dispatchers.Main) {
                                                pbVidLoading.isVisible = false
                                                ivThumbnail.loadImage(localVideoSecretPath)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        if (it.thumbnailUrl.isNull) {
                            ivThumbnail.loadImage(it.url?.getUrlImage())
                        } else {
                            ivThumbnail.loadImage(it.thumbnailUrl?.getUrlImage())
                        }
                    }
                }
                setupForVideo(neVideo = it, neMessage = item, isEncrypted = isEncrypt())
            }
        }
    }

    private fun isEncrypt() = groupType == GroupType.GROUP_TYPE_PRIVATE

    private fun controlVideo(playerExoHelper: PlayerExoHelper, linkUrl: String) {
        with(playerExoHelper) {
            with(_binding) {
                val millisInFuture = (item?.attachment?.video?.duration?.times(1000)?.plus(1000)) ?: 0
                if (isPlaying() && linkUrl == playerExoHelper.linkUrl) {
                    pauseExoPlayer()
                } else {
                    if (isInitialize && !isPlaying() && linkUrl == playerExoHelper.linkUrl) {
                        playExoPlayer()
                    } else {
                        setupExoplayer(videoPlayer)
                        setPlayerClickListener(
                            object : IPlayerClickListener {
                                override fun isShowController(isVisible: Boolean) {
                                    Logger.d("isShowController: $isVisible")
                                }
                            }
                        )
                        setPlayerStateListener(
                            object : IPlayerStateListener {
                                override fun onVideoPause() {
                                    Logger.d("onVideoPause")
                                    showController(binding = _binding, isShow = true, isPause = true)
                                    isPaused = true
                                    isCancelled = false
                                }

                                override fun onVideoResume() {
                                    Logger.d("onVideoResume")
                                    showController(binding = _binding, isShow = false)
                                    isPaused = false
                                    isCancelled = false
                                    timer(millisInFuture - currentPosition() - 1000).start()
                                }

                                override fun onVideoLoading() {
                                    Logger.d("onVideoLoading")
                                    _binding.pbVidLoading.isVisible = true
                                    isPaused = true
                                    isCancelled = false
                                }

                                override fun onVideoEnd() {
                                    Logger.d("onVideoEnd")
                                    isInitialize = false
                                    showController(binding = _binding, isShow = true)
                                    isPaused = false
                                    isCancelled = true
                                    _binding.tvVidDuration.text = TimeUtils.second2String((millisInFuture - 1000) / 1000)
                                }

                                override fun onVideoStarted() {
                                    Logger.d("onVideoStarted")
                                    _binding.pbVidLoading.isGone = true
                                    if (currentPosition() == 0L) {
                                        isPaused = false
                                        isCancelled = false
                                        timer(millisInFuture).start()
                                    }
                                }

                                override fun onVideoError(error: ExoPlaybackException?) {
                                    Logger.d("onVideoError: ${error?.message}")
                                    showController(binding = _binding, isShow = true)
                                    _binding.pbVidLoading.isGone = true
                                }

                                override fun onVideoTracking(progress: Long, duration: Long) {
                                    if (progress.toInt() % 10 == 0) {
                                        Logger.d("onVideoTracking: progress($progress%) - duration: $duration")
                                    }
                                }

                                override fun onVideoSizeChanged(width: Int) {
                                    Logger.d("onVideoSizeChanged")
                                }
                            }
                        )
                        hideController()
                        setMutePlayer() // set this for default is mute
                        runExoPlayer(linkUrl = linkUrl, token = token)
                        isInitialize = true
                        _binding.pbVidLoading.isVisible = true
                        showController(binding = _binding, isShow = false)
                    }
                }
            }
        }
    }

    private var isPaused = false
    private var isCancelled = false
    private fun timer(millisInFuture: Long, countDownInterval: Long = 1000): CountDownTimer {
        return object : CountDownTimer(millisInFuture, countDownInterval) {
            override fun onTick(millisUntilFinished: Long) {
                when {
                    isPaused -> {
                        cancel()
                    }
                    isCancelled -> {
                        cancel()
                    }
                    else -> {
                        _binding.tvVidDuration.text = TimeUtils.second2String(millisUntilFinished / 1000)
                    }
                }
            }

            override fun onFinish() {
            }
        }
    }

    private fun setupForVideo(neVideo: NeVideo, neMessage: NeMessage, isEncrypted: Boolean) {
        with(_binding) {
            neVideo.url?.let { videoUrl ->
                ivVidPlay.clickDebounce {
                    if (isEncrypted) {
                        val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMessage.id}/0"
                        if (FileUtils.isFileExists(localVideoSecretPath)) {
                            controlVideo(playerExoHelper, localVideoSecretPath)
                        } else {
                            pbVidLoading.isVisible = true
                            CoroutineScope(Dispatchers.IO).launch {
                                downloadRepository.downloadFiles(arrayListOf(videoUrl.getUrlImage())).collect {
                                    when (it) {
                                        is ApiResponseSuccess -> {
                                            val responseDownload = it.data
                                            responseDownload?.let { responseBody ->
                                                com.netacom.lite.util.FileUtils.saveEncryptedFileToLocal(
                                                    body = responseBody,
                                                    path = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMessage.id}",
                                                    fileName = "0"
                                                ).let { localVideoSecretPath ->
                                                    withContext(Dispatchers.Main) {
                                                        pbVidLoading.isGone = true
                                                        controlVideo(playerExoHelper, localVideoSecretPath)
                                                    }
                                                }
                                            }
                                        }
                                        is ApiResponseError -> {
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        videoUrl.getUrlImage()?.let { link -> controlVideo(playerExoHelper, link) }
                    }
                }
            }

            ivVidVoice.clickDebounce {
                if (isMute) {
                    isMute = false
                    playerExoHelper.setUnMutePlayer()
                    ivVidVoice.setImageResource(R.drawable.ic_video_unmute)
                } else {
                    isMute = true
                    playerExoHelper.setMutePlayer()
                    ivVidVoice.setImageResource(R.drawable.ic_video_mute)
                }
            }

            videoPlayer.clickDebounce {
                Logger.d("videoPlayer CLICKED")
                if (!playerExoHelper.isPlaying()) {
                    contentClickListener?.onViewVideo(neVideo, bindingAdapterPosition)
                } else {
                    playerExoHelper.pauseExoPlayer()
                    ivVidPlay.isVisible = true
                }
            }

            ivThumbnail.clickDebounce {
                Logger.d("videoPlayer CLICKED")
                contentClickListener?.onViewVideo(neVideo, bindingAdapterPosition)
            }
        }
    }

    private fun showController(
        binding: RowMessageVideoReceiverBinding,
        isShow: Boolean = false,
        isPause: Boolean = false
    ) {
        if (isShow) {
            if (!isPause) {
                binding.ivThumbnail.isVisible = true
            }
            binding.ivVidPlay.isVisible = true
            binding.tvVidDuration.isVisible = true
        } else {
            binding.ivThumbnail.isGone = true
            binding.ivVidPlay.isGone = true
        }
    }
}
