package com.netacom.full.ui.main.chat.viewholder

import android.os.CountDownTimer
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import androidx.work.WorkManager
import com.google.android.exoplayer2.ExoPlaybackException
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.ConvertUtils
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.android_utils.TimeUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isLocalLink
import com.netacom.full.R
import com.netacom.full.databinding.RowMessageVideoSenderBinding
import com.netacom.full.define.MessagePosition
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.utils.AbstractItemClickListener
import com.netacom.full.widget.video.IPlayerClickListener
import com.netacom.full.widget.video.IPlayerStateListener
import com.netacom.full.widget.video.PlayerExoHelper
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageStatusType
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.ui.message.NeMessage
import com.netacom.lite.util.Constants
import com.netacom.lite.util.getUrlImage
import java.util.UUID

class MessageVideoSenderViewHolder(
    val _binding: RowMessageVideoSenderBinding,
    private val contentClickListener: AbstractItemClickListener?,
    private val themeHelperImpl: ThemeHelperImpl,
    private val token: String,
    private val groupType: Int,
    private val playerExoHelper: PlayerExoHelper
) : BaseViewHolder<ViewDataBinding>(_binding) {

    private var isMute: Boolean = true
    private var isInitialize: Boolean = false

    private val dp130 = ConvertUtils.dp2px(150f)
    private val dp200 = ConvertUtils.dp2px(265f)

    fun bind(
        item: NeMessage,
        position: MessagePosition
    ) {
        with(_binding) {
            this.item = item
            messagePosition = position
            ivVidVoice.setImageResource(R.drawable.ic_video_mute)
            item.attachment?.video?.let {
                if (it.width > it.height) {
                    ivThumbnail.layoutParams.width = dp200
                    ivThumbnail.layoutParams.height = dp130

                    videoPlayer.layoutParams.width = dp200
                    videoPlayer.layoutParams.height = dp130
                } else {
                    ivThumbnail.layoutParams.width = dp130
                    ivThumbnail.layoutParams.height = dp200

                    videoPlayer.layoutParams.width = dp130
                    videoPlayer.layoutParams.height = dp200
                }
                if (it.url?.isLocalLink() == true) {
                    ivThumbnail.loadImage(it.url)
                } else {
                    if (isEncrypt()) {
                        val localThumbnailSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}/${Constants.VIDEO_THUMBNAIL}"
                        val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.id}/0"
                        when {
                            FileUtils.isFileExists(localThumbnailSecretPath) -> {
                                ivThumbnail.loadImage(localThumbnailSecretPath)
                            }
                            FileUtils.isFileExists(localVideoSecretPath) -> {
                                ivThumbnail.loadImage(localVideoSecretPath)
                            }
                            else -> {
                                ivThumbnail.loadImage(it.thumbnailUrl?.getUrlImage() ?: it.url.getUrlImage())
                            }
                        }
                    } else {
                        ivThumbnail.loadImage(it.thumbnailUrl?.getUrlImage() ?: it.url.getUrlImage())
                    }
                }
                setupForVideo(neVideo = it, neMessage = item, isEncrypted = isEncrypt())
                if (isEncrypt()) {
                    themeHelperImpl.setThemeColorForSecretChat(imgSend)
                } else {
                    if (item.status == MessageStatusType.MESSAGE_SEEN) {
                        themeHelperImpl.setThemeColorForViews(_binding.imgSend)
                    } else {
                        _binding.imgSend.imageTintList = null
                    }
                }
            }
        }
    }

    private fun isEncrypt() = groupType == GroupType.GROUP_TYPE_PRIVATE

    private fun setupForVideo(neVideo: NeVideo, neMessage: NeMessage, isEncrypted: Boolean) {
//        Logger.d("item video : ${neVideo.url}")

        with(_binding) {
            neVideo.url?.let { videoURL ->
                ivVidPlay.clickDebounce {
                    val playUrl = if (videoURL.split("/").size > 2) {
                        videoURL
                    } else {
                        if (isEncrypted) {
                            val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMessage.id}/0"
                            if (FileUtils.isFileExists(localVideoSecretPath)) {
                                localVideoSecretPath
                            } else {
                                videoURL
                            }
                        } else {
                            videoURL.getUrlImage()
                        }
                    }
                    with(playerExoHelper) {
                        val millisInFuture = (item?.attachment?.video?.duration?.times(1000)?.plus(1000)) ?: 0
                        if (isPlaying() && linkUrl == playUrl) {
                            pauseExoPlayer()
                        } else if (isInitialize && !isPlaying() && linkUrl == playUrl) {
                            playExoPlayer()
                        } else {
                            setupExoplayer(videoPlayer)
                            setPlayerClickListener(
                                object : IPlayerClickListener {
                                    override fun isShowController(isVisible: Boolean) {
                                        Logger.d("isShowController: $isVisible")
                                    }
                                }
                            )
                            setPlayerStateListener(
                                object : IPlayerStateListener {
                                    override fun onVideoPause() {
                                        Logger.d("onVideoPause")
                                        showController(binding = _binding, isShow = true, isPause = true)
                                        isPaused = true
                                        isCancelled = false
                                    }

                                    override fun onVideoResume() {
                                        Logger.d("onVideoResume")
                                        showController(binding = _binding, isShow = false)
                                        isPaused = false
                                        isCancelled = false
                                        timer(millisInFuture - currentPosition() - 1000).start()
                                    }

                                    override fun onVideoLoading() {
                                        Logger.d("onVideoLoading")
                                        _binding.pbVidLoading.isVisible = true
                                        isPaused = true
                                        isCancelled = false
                                    }

                                    override fun onVideoEnd() {
                                        Logger.d("onVideoEnd")
                                        isInitialize = false
                                        showController(binding = _binding, isShow = true)
                                        isPaused = false
                                        isCancelled = true
                                        _binding.tvVidDuration.text = TimeUtils.second2String((millisInFuture - 1000) / 1000)
                                    }

                                    override fun onVideoStarted() {
                                        Logger.d("onVideoStarted")
                                        _binding.pbVidLoading.isGone = true
                                        if (currentPosition() == 0L) {
                                            isPaused = false
                                            isCancelled = false
                                            timer(millisInFuture).start()
                                        }
                                    }

                                    override fun onVideoError(error: ExoPlaybackException?) {
                                        Logger.d("onVideoError: ${error?.message}")
                                        showController(binding = _binding, isShow = true)
                                        _binding.pbVidLoading.isGone = true
                                    }

                                    override fun onVideoTracking(progress: Long, duration: Long) {
                                        if (progress.toInt() % 10 == 0) {
                                            Logger.d("onVideoTracking: progress($progress%) - duration: $duration")
                                        }
                                    }

                                    override fun onVideoSizeChanged(width: Int) {
                                        Logger.d("onVideoSizeChanged")
                                    }
                                }
                            )
                            hideController()
                            setMutePlayer() // set this for default is mute
                            runExoPlayer(linkUrl = playUrl, token = token)
                            isInitialize = true
                            _binding.pbVidLoading.isVisible = true
                            showController(binding = _binding, isShow = false)
                        }
                    }
                }

                ivVidVoice.clickDebounce {
                    if (isMute) {
                        isMute = false
                        playerExoHelper.setUnMutePlayer()
                        ivVidVoice.setImageResource(R.drawable.ic_video_unmute)
                    } else {
                        isMute = true
                        playerExoHelper.setMutePlayer()
                        ivVidVoice.setImageResource(R.drawable.ic_video_mute)
                    }
                }

                videoPlayer.clickDebounce {
                    Logger.d("videoPlayer CLICKED")
                    if (!playerExoHelper.isPlaying()) {
                        contentClickListener?.onViewVideo(neVideo, bindingAdapterPosition)
                    } else {
                        playerExoHelper.pauseExoPlayer()
                    }
                }

                ivThumbnail.clickDebounce {
                    Logger.d("videoPlayer CLICKED")
                    contentClickListener?.onViewVideo(neVideo, bindingAdapterPosition)
                }

                ivVidCancel.clickDebounce {
                    Logger.d("ivVidCancel CLICKED")
                    neVideo.compressId?.let { uuid ->
                        try {
                            val uuidString = UUID.fromString(uuid)
                            WorkManager.getInstance(Utils.getApp()).cancelWorkById(uuidString)
                        } catch (e: IllegalArgumentException) {
                        }
                    }
                    neVideo.uploadId?.let { uuid ->
                        try {
                            val uuidString = UUID.fromString(uuid)
                            WorkManager.getInstance(Utils.getApp()).cancelWorkById(uuidString)
                        } catch (e: IllegalArgumentException) {
                        }
                    }
                    neVideo.mergeId?.let { uuid ->
                        try {
                            val uuidString = UUID.fromString(uuid)
                            WorkManager.getInstance(Utils.getApp()).cancelWorkById(uuidString)
                        } catch (e: IllegalArgumentException) {
                        }
                    }
                }
            }
        }
    }

    private var isPaused = false
    private var isCancelled = false
    private fun timer(millisInFuture: Long, countDownInterval: Long = 1000): CountDownTimer {
        return object : CountDownTimer(millisInFuture, countDownInterval) {
            override fun onTick(millisUntilFinished: Long) {
                when {
                    isPaused -> {
                        cancel()
                    }
                    isCancelled -> {
                        cancel()
                    }
                    else -> {
                        _binding.tvVidDuration.text = TimeUtils.second2String(millisUntilFinished / 1000)
                    }
                }
            }

            override fun onFinish() {
            }
        }
    }

    private fun showController(binding: RowMessageVideoSenderBinding, isShow: Boolean = false, isPause: Boolean = false) {
        if (isShow) {
            if (!isPause) {
                binding.ivThumbnail.isVisible = true
            }
            binding.ivVidPlay.isVisible = true
            binding.tvVidDuration.isVisible = true
        } else {
            binding.ivThumbnail.isGone = true
            binding.ivVidPlay.isGone = true
        }
    }
}
