/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.contact

import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.type.ScreenState
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraFragment
import com.netacom.full.databinding.FragmentContactBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.contact.ContactUtils.SORT_BY_NAME
import com.netacom.full.ui.main.contact.ContactUtils.SORT_BY_TIME
import com.netacom.full.ui.main.contact.adapter.ContactAdapter
import com.netacom.full.ui.main.contact.adapter.ContactAdapter.Companion.CONTACT_TYPE_MAIN
import com.netacom.full.widget.EmptyView
import com.netacom.lite.define.SyncType
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.AppUtils
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

@AndroidEntryPoint
class ContactFragment : BaseCoreCallCameraFragment<FragmentContactBinding, ContactViewModel>(
    R.layout.fragment_contact,
    ContactViewModel::class.java
) {

    companion object {
        const val TAG = "_ContactFragment"
    }

    private lateinit var contactAdapter: ContactAdapter

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    override fun setViewModel(): Int = BR.viewModel

    private var listContact: List<NeUser>? = emptyList()

    override fun initViews() {
        if (ContactUtils.sortSelectedKey.isBlank()) {
            ContactUtils.sortSelectedKey = SORT_BY_NAME
        }
        contactAdapter = ContactAdapter(
            { item, _, _ ->
                /**
                 * Note: This function was used in 6 places. Should be investigated & create the base function.
                 */
                val neContact = item.getItemUser()?._neContact
                Logger.d("ne contact clicked = $neContact")
                neContact?.let {
                    viewModel.startOneByOneChat(it)
                } ?: kotlin.run {
                    showSnackBar(R.string.cant_start_chat)
                }
            },
            { neContact ->
                /**
                 * Make the Audio Call
                 */
                neContact.id?.let { receiverId ->
                    checkCall(receiverId, isVideoEnable = false)
                } ?: let {
                    // TODO
                    // Will be show the Alert dialog or Toast to inform the error.
                }
            },
            { neContact ->
                /**
                 * Make the Video Call
                 */
                neContact.id?.let { receiverId ->
                    checkCall(receiverId, isVideoEnable = true)
                } ?: let {
                    // TODO
                    // Will be show the Alert dialog or Toast to inform the error.
                }
            },
            CONTACT_TYPE_MAIN,
            emptyCallBack = { isEmpty ->
                // Todo: handle action for empty
            }
        )
        with(binding) {
            recyclerView.adapter = contactAdapter
            with(swipeLayout) {
                setOnRefreshListener {
                    isRefreshing = false
                    mainSdkViewModel.syncContact(SyncType.LIST_SYNC_SERVER)
                }
            }
        }
        binding.emptyView.newActionListener = object : EmptyView.NewActionListener {
            override fun onStartNewAction() {
                viewModel.openAddContact()
            }
        }
        initSpinnerSortContact()
        viewModel.cacheContactUI?.let {
            contactAdapter.swapData(it)
        }
    }

    private fun initSpinnerSortContact() {
        ArrayAdapter.createFromResource(
            requireContext(),
            R.array.contact_sort,
            android.R.layout.simple_spinner_item
        ).also { adapter ->
            // Specify the layout to use when the list of choices appears
            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            // Apply the adapter to the spinner
            binding.sortContactSpinner.adapter = adapter
            binding.sortContactSpinner.setSelection(if (ContactUtils.sortSelectedKey == SORT_BY_NAME) 0 else 1, false)
        }

        binding.sortContactSpinner.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                listContact?.let { _listContacts ->
                    ContactUtils.sortSelectedKey = if (position == 0) SORT_BY_NAME else SORT_BY_TIME
                    val contactSort = ContactUtils.sortContacts(sortBy = ContactUtils.sortSelectedKey, listContacts = _listContacts)
                    viewModel.cacheContactUI = contactSort
                    contactAdapter.swapData(contactSort)
                }
            }

            override fun onNothingSelected(parent: AdapterView<*>?) {
            }
        }
    }

    override fun initData() {
        MainScope().launch {
            delay(100)
            checkPermissionContact(
                {
                    mainSdkViewModel.syncContact(SyncType.LIST_SYNC_SERVER)
                    viewModel.listenerContactChange(requireContext())
                },
                {
                    mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
                }
            )
        }
        mainSdkViewModel.listContact.observeOnce {
            listContact = it
            checkBlockedUser(it, ContactUtils.sortSelectedKey)
        }

        viewModel.contactChange.observeOnce { isChanged ->
            if (isChanged) {
                mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
            }
        }
    }

    override fun syncEvent() {
        callEvent()
        binding.toolbar.setOnRightClickListener(
            listener = {
                viewModel.openAddContact()
            }
        )

        binding.toolbar.setOnLeftClickListener(
            listener = {
                binding.flContactContainer.isVisible = true
                viewModel.openSearch()
            }
        )

        binding.llInvite.clickDebounce {
            viewModel.openInvite()
        }

        mainSdkViewModel.contactScreenState.observe { state ->
            if (state.state == ScreenState.EMPTY) {
                if (contactAdapter.itemCount == 0) {
                    binding.emptyView.setScreenState(state)
                }
            } else {
                binding.emptyView.setScreenState(state)
            }
        }
        // Check online
        mainSdkViewModel.userStatus.observeOnce { userStatus ->
            contactAdapter.updateStatus(userStatus)
        }

        viewModel.inviteFriend.observeOnce { phoneNumber ->
            AppUtils.sendSMSIntent(phoneNumber, requireContext())
        }
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(
                imgChooseAvatar,
                tvInviteFiend,
                toolbar
            )
            if (themeHelperImpl.isDarkMode) {
                toolbar.getButtonLeft()!!
            }
            themeHelperImpl.setThemeColorForSubBackground(imgChooseAvatar)
            if (themeHelperImpl.isDarkMode) {
                themeHelperImpl.setThemeColorForViews(binding.toolbar.getButtonLeft()!!, binding.toolbar.getButtonRight()!!)
            }
        }
    }

    private fun checkBlockedUser(listUser: List<NeUser>, sortSelected: String) {
        viewModel.filterContactHasBlocked(listUser, sortSelected) {
            viewModel.cacheContactUI = it
            contactAdapter.swapData(it)
        }
    }
}
