/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.contact

import android.content.res.ColorStateList
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.core.widget.addTextChangedListener
import androidx.lifecycle.lifecycleScope
import com.netacom.base.chat.android_utils.KeyboardUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.getThemeColor
import com.netacom.base.chat.util.isNull
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentContactSearchBinding
import com.netacom.full.ui.main.contact.adapter.RecentContactAdapter
import com.netacom.full.ui.main.contact.adapter.RecentSearchAdapter
import com.netacom.lite.entity.database.contact.DbSearchContactEntity
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.CallbackResult
import com.netacom.lite.util.Constants.EMPTY
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 * Created by Tam Nguyen on 9/4/20.
 */

@AndroidEntryPoint
class ContactSearchFragment : BaseSDKDataFragment<FragmentContactSearchBinding, ContactViewModel>(
    R.layout.fragment_contact_search,
    ContactViewModel::class.java
) {
    private lateinit var recentContactAdapter: RecentContactAdapter
    private lateinit var recentSearchAdapter: RecentSearchAdapter
    private var searchFor = EMPTY
    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        binding.searchHeader.vExpand.isVisible = true
        binding.searchHeader.rlSearchHeader.layoutParams.height =
            requireContext().resources.getDimension(
                R.dimen.dp_88
            ).toInt()

        binding.rcvRecentlyContact.setHasFixedSize(true)
        recentContactAdapter = RecentContactAdapter { neUser: NeUser, _: View, _: Int ->
            saveSearchContactToDB(neUser)
            viewModel.startOneByOneChat(neUser)
        }
        binding.rcvRecentlyContact.adapter = recentContactAdapter

        binding.rcvRecentlySearch.setHasFixedSize(true)
        recentSearchAdapter = RecentSearchAdapter(
            itemClick = null,
            contactClick = { neContact: NeUser?, isSave: Boolean ->
                neContact?.let { _user ->
                    if (isSave) {
                        saveSearchContactToDB(_user)
                        viewModel.startOneByOneChat(_user)
                    } else {
                        viewModel.startOneByOneChat(neContact)
                    }
                }
            },
            groupClick = { neGroup: NeGroup? ->
                neGroup?.let { _group ->
                    val dbSearchContact = DbSearchContactEntity().apply {
                        this.memberId = _group.id?.toLongOrNull()
                        this.time = System.currentTimeMillis()
                        this.memberAvatar = _group.avatar
                        this.memberUserName = _group.name
                    }
                    viewModel.saveSearchContact(dbSearchContact)
                    viewModel.openChat(_group)
                    /**
                     * Start Chat screen & destroy this fragment
                     */
                }
            },
            inviteFriendClick = { neContact: NeUser ->
                neContact.phone?.let { _phoneNumber ->
                    AppUtils.sendSMSIntent(phone = _phoneNumber, context = requireContext())
                } ?: let {
                    /**
                     * Should be show alert dialog/Toast to inform the issue
                     */
                }
            },
            saveRegisterContactClick = { neContact: NeUser ->
                viewModel.actionSearch(neContact)
            },
            saveLocalContact = { neContact: NeUser ->
                viewModel.actionSearch(neContact)
            },
            themeHelperImpl = themeHelperImpl
        )
        binding.rcvRecentlySearch.adapter = recentSearchAdapter
    }

    override fun initData() {
        viewModel.getRecentlyContact(10)
        viewModel.getRecentContactsSearch()
        binding.searchHeader.editText.addTextChangedListener(
            object : TextWatcher {
                override fun beforeTextChanged(
                    s: CharSequence?,
                    start: Int,
                    before: Int,
                    count: Int
                ) {
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    val searchText = s.toString().trim()
                    if (searchText == searchFor) {
                        return
                    }

                    searchFor = searchText.trim()
                    job.cancel()
                    job = SupervisorJob()
                    launch {
                        delay(500) // debounce timeOut
                        if (searchText != searchFor) {
                            return@launch
                        }
                        searchLocalContact(filter = searchFor)
                    }
                }

                override fun afterTextChanged(p0: Editable?) {
                    // enforce editText not to start with space
                    if (p0.toString().startsWith(" ")) {
                        binding.searchHeader.editText.setText("")
                    }
                }
            }
        )
        binding.llRecentlyContact.visibility = View.VISIBLE
    }

    override fun syncEvent() {
        binding.searchHeader.editText.addTextChangedListener {
            it ?: return@addTextChangedListener
            binding.searchHeader.imgClear.visibility = if (it.isEmpty()) View.GONE else View.VISIBLE
        }
        binding.searchHeader.imgClear.clickDebounce {
            binding.searchHeader.editText.setText(EMPTY)
        }
        binding.tvDeleteAll.clickDebounce {
            viewModel.deleteContactSearch(
                callbackResult = object : CallbackResult<Boolean> {
                    override fun callBackSuccess(result: Boolean) {
                        recentSearchAdapter.setData(
                            listSubNeItem = emptyList(),
                            lifecycleScope = lifecycleScope
                        )
                        lifecycleScope.launch(Dispatchers.Main) {
                            binding.tvDeleteAll.visibility = View.GONE
                        }
                    }

                    override fun callBackError(error: String?) {
                    }
                }
            )
        }
        binding.searchHeader.layoutCancel.clickDebounce {
            KeyboardUtils.hideSoftInput(it)
            viewModel.back()
        }
        viewModel.searchContacts.observeOnce { listSubNeItem ->
            if (listSubNeItem.isNull) {
                binding.layoutEmpty.ctlEmptyContainer.isVisible = true
            } else {
                binding.layoutEmpty.ctlEmptyContainer.isGone = true
            }
            recentSearchAdapter.setData(
                listSubNeItem = listSubNeItem,
                filter = searchFor,
                lifecycleScope = lifecycleScope
            )
        }

        binding.layoutEmpty.btnEmpty.clickDebounce {
            viewModel.openAddContact()
        }

        viewModel.recentContacts.observeOnce { listNeUser ->
            recentContactAdapter.display(listNeUser)
        }

        viewModel.recentContactsSearch.observeOnce {
            binding.tvDeleteAll.isGone = it.isEmpty()
            recentSearchAdapter.setData(
                listSubNeItem = it,
                filter = searchFor,
                lifecycleScope = lifecycleScope
            )
        }
    }

    /**
     * WAITING!!!!  Need to discuss with the iOS team to find out the final solution
     */
    private fun searchLocalContact(filter: String) {
        if (filter.isNotEmpty()) {
            binding.flRecentSearch.isGone = true
            binding.llRecentlyContact.isGone = true
            viewModel.searchLocalContact(
                filter = filter
            )
        } else {
            binding.flRecentSearch.isVisible = true
            binding.llRecentlyContact.isVisible = true
            // load data contact get db
            viewModel.getRecentContactsSearch()
        }
    }

    override fun setupTheme() {
        themeHelperImpl.setHeaderTheme(binding.searchHeader.rlSearchHeader)
        themeHelperImpl.setThemeColorForViews(binding.layoutEmpty.btnEmpty)
        binding.layoutEmpty.btnEmpty.backgroundTintList = ColorStateList.valueOf(getThemeColor(themeHelperImpl.mainColor))
        themeHelperImpl.setButtonBackgroundAndText(binding.layoutEmpty.btnEmpty)
    }

    private fun saveSearchContactToDB(neUser: NeUser) {
        val dbSearchContact = DbSearchContactEntity().apply {
            this.memberId = neUser.id
            this.time = System.currentTimeMillis()
            this.memberAvatar = neUser.avatar
            this.memberPhone = neUser.getPhone
            this.memberUserName = neUser.username
        }
        viewModel.saveSearchContact(dbSearchContact)
    }
}
