/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.contact

import android.content.ContentProviderOperation
import android.content.ContentResolver
import android.content.Context
import android.database.Cursor
import android.graphics.Typeface
import android.net.Uri
import android.provider.ContactsContract
import android.text.Spannable
import android.text.SpannableString
import android.text.style.StyleSpan
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.ui.main.contact.model.ItemNeContact
import com.netacom.full.ui.main.contact.model.SubNeContact
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.CallbackResult
import java.util.Locale
import java.util.regex.Pattern

/**
 * Created by Tam Nguyen on 9/1/20.
 */

object ContactUtils {

    const val SORT_BY_NAME = "SORT_BY_NAME"
    const val SORT_BY_TIME = "SORT_BY_TIME"

    var sortSelectedKey = ""

    fun sortContacts(sortBy: String = SORT_BY_NAME, listContacts: List<NeUser>): List<SubNeContact> {
        val result = mutableListOf<SubNeContact>()
        when (sortBy) {
            SORT_BY_NAME -> {
                val regex = "[A-Za-z]"
                val pattern = Pattern.compile(regex)
                listContacts.sortedBy {
                    it.getDisplayName.trim().toUpperCase(Locale.getDefault())
                }.let {
                    var headers = ""
                    var count = 0
                    for (entry in it) {
                        val sortName = entry.getDisplayName.trim().split(" ").firstOrNull().orEmpty()
                        if (sortName.isNotEmpty()) {
                            var header = sortName.first().toString()
                            header = if (pattern.matcher(header).matches()) header.toUpperCase() else "#"
                            if (headers.contains(header)) {
                                if (header != "#") {
                                    result.add(
                                        result.size - count,
                                        SubNeContact(
                                            _itemNeContact = ItemNeContact(_neContact = entry)
                                        )
                                    )
                                } else {
                                    count += 1
                                    result.add(
                                        SubNeContact(
                                            _itemNeContact = ItemNeContact(_neContact = entry)
                                        )
                                    )
                                }
                            } else {
                                headers += header
                                if (header != "#") {
                                    result.add(
                                        result.size - count,
                                        SubNeContact(_neHeader = header)
                                    )
                                    result.add(
                                        result.size - count,
                                        SubNeContact(
                                            _itemNeContact = ItemNeContact(_neContact = entry)
                                        )
                                    )
                                } else {
                                    count += 2
                                    result.add(SubNeContact(_neHeader = header))
                                    result.add(
                                        SubNeContact(
                                            _itemNeContact = ItemNeContact(_neContact = entry)
                                        )
                                    )
                                }
                            }
                        } else {
                            result.add(
                                SubNeContact(_itemNeContact = ItemNeContact(_neContact = entry))
                            )
                        }
                    }
                }
            }
            SORT_BY_TIME -> {
                listContacts.sortedByDescending { it.lastSeenAt }.forEach {
                    result.add(SubNeContact(_itemNeContact = ItemNeContact(_neContact = it)))
                }
            }
            else -> {
                listContacts.forEach {
                    result.add(SubNeContact(_itemNeContact = ItemNeContact(_neContact = it)))
                }
            }
        }
        return result
    }

    fun spanText(filter: String, content: String): Spannable {
        val span = SpannableString(content)

        if (filter.isNotEmpty() && content.contains(filter)) {
            val startSpan = content.indexOf(string = filter, ignoreCase = true)

            span.setSpan(
                StyleSpan(Typeface.BOLD),
                startSpan,
                startSpan + filter.length,
                Spannable.SPAN_EXCLUSIVE_INCLUSIVE
            )
        }

        return span
    }

    fun hasAddedFriend(id: Long, listContact: List<NeUser>): Boolean {
        listContact.find {
            it.id == id && !it.isDeleted
        }.let {
            return it.isNotNull
        }
    }

    fun getContactIDByPhoneNumber(context: Context, phone: String, callbackResult: CallbackResult<String>) {
        val isPhonePrefix = phone.contains("+84")
        Logger.d("getPhoneNumber=$phone")
        val uri: Uri = Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(phone))
        var id: String
        val contentResolver: ContentResolver = context.contentResolver
        val contactLookup: Cursor? = contentResolver.query(
            uri,
            arrayOf(
                ContactsContract.Contacts._ID,
                ContactsContract.PhoneLookup.DISPLAY_NAME
            ),
            null,
            null,
            null
        )
        contactLookup.use { _contactLookup ->
            if (_contactLookup != null && _contactLookup.count > 0) {
                _contactLookup.moveToNext()
                id = _contactLookup.getString(_contactLookup.getColumnIndex(ContactsContract.Contacts._ID))
                getRawContactId(context, id)?.let { callbackResult.callBackSuccess(it) }
            } else if (isPhonePrefix) {
                getContactIDByPhoneNumber(context, phone.replace("+84", "0"), callbackResult)
            } else {
                callbackResult.callBackError("")
            }
            _contactLookup?.close()
        }
    }

    fun updatePhoneContact(
        context: Context,
        contact_id: String,
        newName: String,
        callbackResult: CallbackResult<String>
    ) {
        try {
            val operations = ArrayList<ContentProviderOperation>()
            ContentProviderOperation.newUpdate(ContactsContract.Data.CONTENT_URI).apply {
                val selection =
                    "${ContactsContract.Data.RAW_CONTACT_ID} = ? AND (${ContactsContract.Data.MIMETYPE} = ? OR ${ContactsContract.Data.MIMETYPE} = ?)"
                val selectionArgs =
                    arrayOf(contact_id, ContactsContract.CommonDataKinds.StructuredName.CONTENT_ITEM_TYPE, ContactsContract.CommonDataKinds.Organization.CONTENT_ITEM_TYPE)
                withSelection(selection, selectionArgs)
                withValue(ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME, newName)
                withValue(ContactsContract.CommonDataKinds.StructuredName.MIDDLE_NAME, "")
                withValue(ContactsContract.CommonDataKinds.StructuredName.FAMILY_NAME, "")
                withValue(ContactsContract.CommonDataKinds.StructuredName.SUFFIX, "")
                operations.add(build())
            }

            // delete nickname
            ContentProviderOperation.newDelete(ContactsContract.Data.CONTENT_URI).apply {
                val selection = "${ContactsContract.Data.RAW_CONTACT_ID} = ? AND ${ContactsContract.Data.MIMETYPE} = ? "
                val selectionArgs = arrayOf(contact_id, ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME)
                withSelection(selection, selectionArgs)
                operations.add(build())
            }

            // add nickname
            ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI).apply {
                withValue(ContactsContract.Data.RAW_CONTACT_ID, contact_id)
                withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME)
                withValue(ContactsContract.CommonDataKinds.StructuredName.GIVEN_NAME, newName)
                operations.add(build())
            }
            context.contentResolver.applyBatch(ContactsContract.AUTHORITY, operations)
            callbackResult.callBackSuccess(newName)
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            callbackResult.callBackError(e.message)
        }
    }

    private fun getRawContactId(context: Context, contactId: String): String? {
        var res = ""
        val uri = ContactsContract.RawContacts.CONTENT_URI
        val projection = arrayOf(ContactsContract.RawContacts._ID)
        val selection = ContactsContract.RawContacts.CONTACT_ID + " = ?"
        val selectionArgs = arrayOf(contactId)
        val c: Cursor? = context.contentResolver.query(uri, projection, selection, selectionArgs, null)
        if (c != null && c.moveToFirst()) {
            res = c.getString(c.getColumnIndex(ContactsContract.RawContacts._ID))
            c.close()
        }
        return res
    }
}
