/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.contact

import android.text.Editable
import android.text.TextWatcher
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.network.ResultData
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupInviteFriendBinding
import com.netacom.full.ui.main.contact.adapter.InviteFriendAdapter
import com.netacom.full.utils.DialogUtil
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants.EMPTY
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 * Created by Tam Nguyen on 9/16/20.
 */

@AndroidEntryPoint
class InviteFriendFragment : BaseSDKBottomDialog<PopupInviteFriendBinding, ContactViewModel>(
    R.layout.popup_invite_friend,
    ContactViewModel::class.java
) {

    companion object {
        const val TAG = "_InviteFriendFragment"
    }

    private lateinit var inviteFriendAdapter: InviteFriendAdapter
    private val neContacts = mutableListOf<NeUser>()

    private fun removeNeContact(neContact: NeUser, position: Int = 0) {
        for (i in 0 until neContacts.size) {
            if (neContacts[i].phone == neContact.phone) {
                neContacts.removeAt(i)
                changeInviteCount(neContacts.size)
                break
            }
        }
    }

    private fun addNeContact(neContact: NeUser) {
        neContacts.add(neContact)
        changeInviteCount(neContacts.size)
    }

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        changeInviteCount(neContacts.size)

        binding.toolbarInfo.setColorTextLeft(
            ContextCompat.getColor(requireContext(), R.color.color_sub_text_3)
        )
        binding.toolbarInfo.setColorTextRight(
            ContextCompat.getColor(requireContext(), R.color.color_sub_text_3)
        )
        binding.toolbarInfo.setColorTextTitle(
            ContextCompat.getColor(requireContext(), R.color.color_sub_text)
        )

        binding.recyclerView.layoutManager = LinearLayoutManager(context)
        inviteFriendAdapter = InviteFriendAdapter(
            { _, _, _ ->
            },
            { neContact: NeUser, _: Int, isCheck: Boolean ->
                if (isCheck) addNeContact(neContact)
                else removeNeContact(neContact = neContact)
            },
            { phoneNumber: String, name: String ->
                viewModel.openInviteFriend(name, phoneNumber)
            },
            {
                DialogUtil.showError(
                    context = requireContext(),
                    title = R.string.popup_confirm,
                    message = R.string.message_maximum_invite_friends,
                    cancelable = false
                )
            },
            themeHelperImpl
        )
        binding.recyclerView.adapter = inviteFriendAdapter

        binding.toolbarInfo.setOnLeftClickListener {
            dismiss()
        }

        binding.icClear.clickDebounce {
            binding.editSearch.setText(EMPTY)
        }

        binding.editSearch.addTextChangedListener(
            object : TextWatcher {
                private var searchFor = EMPTY
                override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                    val searchText = s.toString().trim()
                    if (searchText == searchFor) {
                        return
                    }

                    searchFor = searchText

                    lifecycleScope.launch {
                        delay(500) // debounce timeOut
                        if (searchText != searchFor) {
                            return@launch
                        }
                        inviteFriendAdapter.filter(
                            filterBy = searchFor,
                            lifecycleScope = lifecycleScope
                        )
                    }
                }

                override fun afterTextChanged(p0: Editable?) {
                }
            }
        )

        binding.tvInviteFriend.clickDebounce {
            if (neContacts.isNullOrEmpty()) {
                dismiss()
            } else {
                var phoneUsers: String? = ""
                for (i in 0 until neContacts.size) {
                    when (i) {
                        neContacts.size - 1 -> {
                            phoneUsers += neContacts[i].phone.toString()
                        }
                        else -> {
                            phoneUsers += neContacts[i].phone.toString() + ";"
                        }
                    }
                }

                AppUtils.sendSMSIntent(phone = phoneUsers ?: "", context = requireContext())
                dismiss()
            }
        }
    }

    override fun initData() {
        viewModel.getListContactNotRegister()
        viewModel.listContactNotRegister.observeOnce { resultData ->
            when (resultData) {
                is ResultData.Success -> {
                    resultData.data?.let {
                        inviteFriendAdapter.setData(
                            neContacts = it,
                            lifecycleScope = lifecycleScope
                        )
                    }
                }
                else -> Unit
            }
        }
    }

    override fun setupTheme() {
//        binding.toolbarInfo.getTextRight()?.let { themeHelperImpl.setThemeColorForViews(it) }
        themeHelperImpl.setThemeColorForViews(binding.tvInviteFriend)
    }

    private fun changeInviteCount(count: Int) {
        binding.toolbarInfo.setTextRight(String.format(requireContext().resources.getString(R.string.str_invite_friend_count), count))
        if (count == 0) {
            binding.tvInviteFriend.isGone = true
        } else {
            binding.tvInviteFriend.text = resources.getQuantityString(R.plurals.btn_invite_friend_count, count, count)
            binding.tvInviteFriend.isVisible = true
        }
    }
}
