/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.contact

import android.os.Bundle
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewInviteFriendPopupBinding
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.Constants.EMPTY
import dagger.hilt.android.AndroidEntryPoint

/**
 * Created by Tam Nguyen on 9/17/20.
 */

@AndroidEntryPoint
class InviteFriendInfoFragment : BaseSDKBottomDialog <ViewInviteFriendPopupBinding, ContactViewModel>(
    R.layout.view_invite_friend_popup,
    ContactViewModel::class.java
) {

    companion object {
        const val TAG: String = "_InviteFriendInfoFragment"
    }

    private val args: InviteFriendInfoFragmentArgs by navArgs()

    private var name: String? = EMPTY
    private var phone: String? = EMPTY

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        name = args.name
        phone = args.phone
    }

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL
    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        binding.name = name
        binding.phone = phone

        binding.tvInvite.text = String.format(getString(R.string.text_invite_friend), getString(R.string.app_name))

        binding.tvInvite.clickDebounce {
            phone?.let { _phone ->
                AppUtils.sendSMSIntent(phone = _phone, requireContext())
                dismiss()
            }
        }
        binding.toolbar.setOnLeftClickListener {
            dismiss()
        }
    }

    override fun initData() {
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(binding.textView5, binding.toolbar.getButtonLeft()!!)
    }
}
