/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.contact.adapter

import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.AppCompatImageView
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.LifecycleCoroutineScope
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseMultiTypeListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.unAccentText
import com.netacom.full.R
import com.netacom.full.databinding.ItemInviteFriendBinding
import com.netacom.full.databinding.ItemRcvUserGroupHeaderBinding
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.full.ui.main.contact.model.ItemNeContact
import com.netacom.full.ui.main.contact.model.SubNeContact
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * Created by Tam Nguyen on 9/16/20.
 */

class InviteFriendAdapter(
    itemClick: ((SubNeContact, View, Int) -> Unit)?,
    private val checkClick: ((NeUser, Int, Boolean) -> Unit),
    private val inviteFriend: ((String, String) -> Unit),
    private val isFull: (() -> Unit),
    private val themeHelperImpl: ThemeHelperImpl
) : BaseMultiTypeListSimpleAdapter<SubNeContact, ViewDataBinding>(itemClick, diff = InviteFriendDiffUtil()) {

    companion object {
        private const val CONTACT_HEADER = 0
        private const val CONTACT_BODY = 1
    }

    private var defaultUserSelected = ""
    private var countSelectedSize = 0
    private val neContacts = mutableListOf<NeUser>()

    override fun bindMultiType(position: Int): Int {
        return if (getItem(position)?.isHeader() == true) CONTACT_HEADER else CONTACT_BODY
    }

    fun setData(neContacts: List<NeUser>, lifecycleScope: LifecycleCoroutineScope) {
        this.neContacts.clear()
        this.neContacts.addAll(neContacts)
        lifecycleScope.launch(Dispatchers.IO) {
            val newList = ContactUtils.sortContacts(listContacts = neContacts)
            withContext(Dispatchers.Main) {
                display(newList)
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        return when (viewType) {
            CONTACT_HEADER -> BaseViewHolder(
                inflateView(parent, R.layout.item_rcv_user_group_header) as ItemRcvUserGroupHeaderBinding
            )
            CONTACT_BODY -> BaseViewHolder(
                inflateView(parent, R.layout.item_invite_friend) as ItemInviteFriendBinding
            )
            else -> BaseViewHolder(
                inflateView(parent, R.layout.item_invite_friend) as ItemInviteFriendBinding
            )
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        getItem(position)?.let { item ->
            with(holder) {
                when (getItemViewType(position)) {
                    CONTACT_HEADER -> bindContactHeader(
                        this,
                        subNeContact = item
                    )
                    CONTACT_BODY -> bindContactBody(
                        this,
                        _itemNeContact = item._itemNeContact,
                        isDivider = (layoutPosition != (itemCount - 1)),
                        position
                    )
                }
                binding.executePendingBindings()
            }
        }
    }

    private fun bindContactHeader(
        holder: BaseViewHolder<ViewDataBinding>,
        subNeContact: SubNeContact
    ) {
        with(holder.binding as ItemRcvUserGroupHeaderBinding) {
            this.header = subNeContact._neHeader ?: "#"
        }
    }

    private fun bindContactBody(
        holder: BaseViewHolder<ViewDataBinding>,
        _itemNeContact: ItemNeContact?,
        isDivider: Boolean,
        position: Int
    ) {
        with(holder.binding as ItemInviteFriendBinding) {
            this.item = _itemNeContact?._neContact
            this.hasDivider = isDivider
            themeHelperImpl.setThemeColorForViews(ivCheck)
            if (_itemNeContact?.isChecked() == true) {
                this.ivCheck.setImageResource(R.drawable.ic_vector_check)
            } else {
                this.ivCheck.setImageBitmap(null)
            }

            this.consLayoutMain.clickDebounce {
                val name = _itemNeContact?._neContact?.getDisplayName
                _itemNeContact?._neContact?.phone?.let { phoneNumber ->
                    inviteFriend(phoneNumber, name.orEmpty())
                    // listener?.onInviteFriend(phoneNumber, name.orEmpty())
                }
            }

            if (_itemNeContact?._neContact?.phone == defaultUserSelected) {
                _itemNeContact.setChecked(true)
            }

            this.btnCheckbox.clickDebounce {
                _itemNeContact?.let { itemNeContact ->
                    checkClickCheckBox(
                        itemMember = itemNeContact,
                        ivCheck = this.ivCheck,
                        position = position
                    )
                }
            }
        }
    }

    private fun checkClickCheckBox(
        itemMember: ItemNeContact,
        ivCheck: AppCompatImageView,
        position: Int
    ) {
        if (itemMember.isChecked()) {
            /*
            * check -> uncheck
            * */
            if (countSelectedSize > 0) countSelectedSize--
            itemMember.setChecked(false)
            ivCheck.setImageBitmap(null)
            itemMember._neContact?.let { data ->
                checkClick(data, position, false)
            }
            // notifyDataSetChanged()
        } else {
            /*
            * uncheck -> check
            * */
            if (countSelectedSize < 20) {
                countSelectedSize++
                itemMember.setChecked(true)
                ivCheck.setImageResource(R.drawable.ic_single_check)

                itemMember._neContact?.let { data ->
                    checkClick(data, position, true)
                }
            } else {
                isFull()
            }
        }
    }

    fun filter(filterBy: String, lifecycleScope: LifecycleCoroutineScope) {
        lifecycleScope.launch(Dispatchers.IO) {
            val termContact = neContacts.filter {
                var result: Boolean
                result = it.getDisplayName.unAccentText()?.contains(
                    filterBy,
                    ignoreCase = true
                ) ?: false
                if (!result) {
                    result = it.phone?.contains(filterBy, ignoreCase = true) == true
                }
                Logger.d("_InviteFriendAdapter result = $result")
                result
            }

            val newList = ContactUtils.sortContacts(listContacts = termContact)
            withContext(Dispatchers.Main) {
                display(newList)
            }
        }
    }

    private class InviteFriendDiffUtil : DiffUtil.ItemCallback<SubNeContact>() {
        override fun areItemsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            return if (oldItem.isHeader() && newItem.isHeader()) {
                true
            } else !oldItem.isHeader() && !newItem.isHeader()
        }

        override fun areContentsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            if (!oldItem.isHeader() && !newItem.isHeader()) {
                return oldItem._itemNeContact?._neContact?.phone == newItem._itemNeContact?._neContact?.phone
            }
            return false
        }
    }
}
