/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.contact.adapter

import android.view.View
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.logger.Logger
import com.netacom.full.R
import com.netacom.full.databinding.ItemRecentlyContactBinding
import com.netacom.lite.entity.ui.user.NeUser

/**
 * Created by Tam Nguyen on 9/4/20.
 */

class RecentContactAdapter(itemClick: ((NeUser, View, Int) -> Unit)?) : BaseListSimpleAdapter<NeUser, ItemRecentlyContactBinding>(itemClick, diff = RecentContactDiff()) {

    override fun bind(
        item: NeUser,
        holder: BaseViewHolder<ItemRecentlyContactBinding>,
        position: Int
    ) {
        with(holder.binding) {
            Logger.d("_ContactSearchFragment bindItem: NeUser")
            this.item = item
        }
    }

    override val layout = R.layout.item_recently_contact

    private class RecentContactDiff : DiffUtil.ItemCallback<NeUser>() {
        override fun areItemsTheSame(oldItem: NeUser, newItem: NeUser): Boolean {
            return oldItem.id == newItem.id
        }

        override fun areContentsTheSame(oldItem: NeUser, newItem: NeUser): Boolean {
            return oldItem == newItem
        }
    }
}
