package com.netacom.full.ui.main.group

import android.app.Activity
import android.content.Intent
import android.net.Uri
import android.provider.MediaStore
import androidx.core.content.FileProvider
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewChooseImagePopupBinding
import com.netacom.lite.util.AppUtils
import java.io.File
import java.io.IOException

class ChooseImageDialog : BaseSDKBottomDialog<ViewChooseImagePopupBinding, GroupViewModel>(
    R.layout.view_choose_image_popup,
    GroupViewModel::class.java
) {
    private val REQUEST_SELECT_GALLERY_CODE = 1111
    private val REQUEST_TAKE_IMAGE_CODE = 1112

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_SMALL

    private var photoFile: File? = null

    override fun initViews() {
    }

    override fun initData() {
        binding.llPhotoLibrary.clickDebounce {
            requestOpenGallery()
        }

        binding.llTakePhoto.clickDebounce {
            requestOpenCamera()
        }
    }

    override fun setupTheme() {
    }

    private fun requestOpenGallery() {
        val pickIntent = Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI)
        pickIntent.type = "image/*"
        val chooserIntent = Intent.createChooser(pickIntent, "Select Image")

        startActivityForResult(chooserIntent, REQUEST_SELECT_GALLERY_CODE)
    }

    private fun requestOpenCamera() {
        checkPermissionCamera(
            {
                val takePictureIntent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
                if (takePictureIntent.resolveActivity(requireActivity().packageManager) != null) {
                    var takePhotoFile: File? = null
                    try {
                        takePhotoFile = AppUtils.createImageFile(requireActivity())
                    } catch (ex: IOException) {
                        ex.printStackTrace()
                    }
                    if (takePhotoFile != null) {
                        val photoURI: Uri = FileProvider.getUriForFile(
                            requireContext(),
                            "com.netacom.netalo.sdk.dev" + ".provider",
                            takePhotoFile
                        )
                        photoFile = takePhotoFile
                        takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, photoURI)
                        startActivityForResult(takePictureIntent, REQUEST_TAKE_IMAGE_CODE)
                    }
                }
            },
            {}
        )
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, intent: Intent?) {
        super.onActivityResult(requestCode, resultCode, intent)
        if (resultCode == Activity.RESULT_OK) {
            when (requestCode) {
                REQUEST_SELECT_GALLERY_CODE -> {
                    intent?.let {
                        val imageUri = intent.getData()
                        imageUri?.let {
                            uri ->
                            viewModel.onBack()
                            viewModel.postImage(uri)
                        }
                    }
                }
                REQUEST_TAKE_IMAGE_CODE -> {
                    viewModel.onBack()
                    photoFile?.let {
                        viewModel.postImage(Uri.fromFile(it))
                    }
                }
            }
        }
    }
}
