package com.netacom.full.ui.main.group

import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewDisplayImageChatPopupBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class DisplaySingleImageDialog : BaseSDKBottomDialog <ViewDisplayImageChatPopupBinding, GroupViewModel>(
    R.layout.view_display_image_chat_popup,
    GroupViewModel::class.java
) {

    val args: DisplaySingleImageDialogArgs by navArgs()

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        binding.ivAvatar.loadImage(args.imageId, R.drawable.ic_image_holder)
        binding.icClose.clickDebounce {
            dismiss()
        }
    }

    override fun initData() {
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(binding.icClose)
    }
}
