package com.netacom.full.ui.main.group

import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.google.android.material.tabs.TabLayout
import com.netacom.base.chat.adapter.MediaViewPagination
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.logger.Logger
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDialog
import com.netacom.full.databinding.FragmentGalleryBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.group.adapter.GalleryAdapter
import com.netacom.lite.define.GroupType
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.media.NeMedia
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class GalleryFragment : BaseSDKDialog<GroupViewModel, FragmentGalleryBinding>(
    R.layout.fragment_gallery,
    GroupViewModel::class.java
) {
    override fun setLayoutHeight() = DialogDef.LAYOUT_FULL
    override fun setViewModel(): Int = BR.viewModel

    private var galleryList = mutableListOf<NeMedia>()
    private var listImages: MutableList<NeMedia> = mutableListOf()
    private var listVideos: MutableList<NeMedia> = mutableListOf()
    private var listFiles: MutableList<NeMedia> = mutableListOf()

    private lateinit var galleryAdapter: GalleryAdapter

    private var mediaViewPagination: MediaViewPagination? = null
    private var neGroup: NeGroup? = null
    private var galleryTabType = MessageType.MESSAGE_TYPE_IMAGE
    private var countGetData = 0

    // This is flag for show gallery in ChatInfo Screen
    private var isShowMemberInfo = false

    // This is flag for show gallery in ViewMedia Screen
    private var isViewMediaFragment = false

    // This is flag for show gallery in Single UserInfo Screen
    private var isViewSingle = false

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    private var galleryCallBack: GalleryCallBack? = null

    override fun initViews() {
        Logger.d("Refactor Gallery: Init")
        with(binding) {
            val arrGalleryTab = requireContext().resources.getStringArray(R.array.galleries_tab)
            for (tabName in arrGalleryTab) {
                tabGallery.addTab(tabGallery.newTab().setText(tabName))
            }

            mediaViewPagination = MediaViewPagination(
                recyclerView = rcvGalleryContent,
                loadMore = {
                    neGroup?.id?.toLongOrNull()?.let { groupId ->
                        viewModel.loadMoreMedia(groupId = groupId, offset = galleryList.size, mediaType = galleryTabType, isViewMediaFragment = isViewMediaFragment)
                    }
                },
            )

            neGroup?.id?.toLongOrNull()?.let { groupId ->
                progressBarLoadMedia.isVisible = true
                viewModel.getMediaListDbByGroupId(groupId, isViewSingle)
            }
        }
    }

    override fun initData() {
        galleryAdapter = GalleryAdapter(
            { item, _, _ ->
                when (item.mediaType) {
                    MessageType.MESSAGE_TYPE_IMAGE, MessageType.MESSAGE_TYPE_VIDEO -> {
                        if (isViewMediaFragment) {
                            galleryCallBack?.onOpenMedia(item)
                        } else {
                            neGroup?.let { group ->
                                viewModel.goToMediaView(item, group)
                            }
                        }
                    }

                    MessageType.MESSAGE_TYPE_FILE -> {
                        item.attachments?.file?.let {
                            mainSdkViewModel.handleFile(
                                viewModel.getGroupDbById(item.groupId.toString())?.groupType == GroupType.GROUP_TYPE_PRIVATE,
                                item.messId,
                                it,
                                requireContext()
                            )
                        }
                    }
                }
            },
            galleryTabType,
            themeHelperImpl,
            neGroup?.type == GroupType.GROUP_TYPE_PRIVATE
        )

        binding.tabGallery.addOnTabSelectedListener(
            object : TabLayout.OnTabSelectedListener {
                override fun onTabSelected(tab: TabLayout.Tab?) {
                    when (tab?.position) {
                        ChatInfoFragment.SELECTED_IMAGE_POSITION -> {
                            Logger.d("Refactor Gallery: SELECTED_IMAGE_POSITION")
                            galleryTabType = MessageType.MESSAGE_TYPE_IMAGE
                            if (countGetData > 0) countGetData = 0
                        }
                        ChatInfoFragment.SELECTED_VIDEO_POSITION -> {
                            Logger.d("Refactor Gallery: MESSAGE_TYPE_VIDEO")
                            galleryTabType = MessageType.MESSAGE_TYPE_VIDEO
                            if (countGetData > 0) countGetData = 0
                        }
                        ChatInfoFragment.SELECTED_FILE_POSITION -> {
                            Logger.d("Refactor Gallery: MESSAGE_TYPE_FILE")
                            galleryTabType = MessageType.MESSAGE_TYPE_FILE
                            if (countGetData > 0) countGetData = 0
                        }
                    }
                    displayGalleryData()
                }

                override fun onTabUnselected(tab: TabLayout.Tab?) {
                }

                override fun onTabReselected(tab: TabLayout.Tab?) {
                }
            }
        )

        viewModel.mediaData.observeOnce {
            binding.progressBarLoadMedia.isGone = true
            if (it.isNotEmpty()) {
                collectData(it.toMutableList(), false)
            }
            displayGalleryData()
        }

        viewModel.listNeMedia.observeOnce {
            binding.progressBarLoadMedia.isGone = true
            Logger.d("Refactor Gallery: listNeMedia - ${it.size}")
            if (it.isNotEmpty()) {
                collectData(it.toMutableList(), false)
            }
            displayGalleryData()
        }

        viewModel.listNeMediaLoadMore.observeOnce {
            binding.progressBarLoadMedia.isGone = true
            if (it.isNotEmpty()) {
                collectData(it.toMutableList(), true)
            }
            displayGalleryData()
        }

        if (isViewSingle) {
            viewModel.singleMediaData.observeOnce {
                binding.progressBarLoadMedia.isGone = true
                collectData(it.toMutableList(), false)
                displayGalleryData()
            }
        }

        if (isViewMediaFragment) {
            viewModel.listNeMediaFragment.observeOnce {
                if (it.isNotEmpty()) {
                    collectData(it.toMutableList(), false)
                }
                displayGalleryData()
            }
        }
    }

    private fun displayGalleryData() {
        when (galleryTabType) {
            MessageType.MESSAGE_TYPE_IMAGE -> {
                if (listImages.isNotEmpty()) {
                    binding.tvEmpty.isGone = true
                    binding.rcvGalleryContent.layoutManager = GridLayoutManager(requireContext(), 4)
                    binding.rcvGalleryContent.adapter = galleryAdapter
                } else {
                    binding.tvEmpty.text = StringUtils.getString(R.string.text_empty_photo)
                    binding.tvEmpty.isVisible = true
                    getMedia(MessageType.MESSAGE_TYPE_IMAGE)
                    countGetData += 1
                }
            }
            MessageType.MESSAGE_TYPE_VIDEO -> {
                if (listVideos.isNotEmpty()) {
                    binding.tvEmpty.isGone = true
                    binding.rcvGalleryContent.layoutManager = GridLayoutManager(requireContext(), 4)
                    binding.rcvGalleryContent.adapter = galleryAdapter
                } else {
                    binding.tvEmpty.text = StringUtils.getString(R.string.text_empty_video)
                    binding.tvEmpty.isVisible = true
                    getMedia(MessageType.MESSAGE_TYPE_VIDEO)
                    countGetData += 1
                }
            }

            MessageType.MESSAGE_TYPE_FILE -> {
                if (listFiles.isNotEmpty()) {
                    binding.tvEmpty.isGone = true
                    binding.rcvGalleryContent.layoutManager = LinearLayoutManager(requireContext())
                    binding.rcvGalleryContent.adapter = galleryAdapter
                } else {
                    binding.tvEmpty.text = StringUtils.getString(R.string.text_empty_file)
                    binding.tvEmpty.isVisible = true
                    getMedia(MessageType.MESSAGE_TYPE_FILE)
                    countGetData += 1
                }
            }
        }

        if (galleryTabType != galleryAdapter.viewType) {
            galleryAdapter.displayList(galleryList, galleryTabType)
        } else {
            if (galleryAdapter.itemCount != galleryList.size) {
                galleryAdapter.displayList(galleryList, galleryTabType)
            }
        }
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(tabGallery)
        }
    }

    fun setGroup(group: NeGroup) {
        Logger.d("Refactor Gallery: setGroup ${group.id}")
        neGroup = group
    }

    fun setIsShowMember(isShow: Boolean) {
        isShowMemberInfo = isShow
    }

    fun setIsViewMedia(isView: Boolean) {
        isViewMediaFragment = isView
    }

    fun setIsViewSingle(isSingle: Boolean) {
        isViewSingle = isSingle
    }

    fun setDataList(data: MutableList<NeMedia>, isAdd: Boolean) {
        binding.progressBarLoadMedia.isGone = true
        if (data.isNotEmpty()) {
            collectData(data, isAdd)
            displayGalleryData()
        }
    }

    interface GalleryCallBack {
        fun onOpenMedia(media: NeMedia)
    }

    fun setGalleryCallBack(callBack: GalleryCallBack) {
        galleryCallBack = callBack
    }

    private fun collectData(data: MutableList<NeMedia>, isAdd: Boolean) {
        if (isAdd) {
            galleryList.addAll(data)
            listImages.addAll(data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_IMAGE })
            listVideos.addAll(data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_VIDEO })
            listFiles.addAll(data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_FILE })
        } else {
            galleryList = data
            listImages = data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_IMAGE }.toMutableList()
            listVideos = data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_VIDEO }.toMutableList()
            listFiles = data.filter { neMedia -> neMedia.mediaType == MessageType.MESSAGE_TYPE_FILE }.toMutableList()
        }
    }

    private fun getMedia(mediaType: Int) {
        neGroup?.id?.toLongOrNull()?.let { groupId ->
            if (countGetData >= 3) return
            viewModel.getMediaForGroup(groupId = groupId, mediaType = mediaType, isViewMediaFragment = isViewMediaFragment)
        }
    }
}
