package com.netacom.full.ui.main.group

import android.os.Bundle
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupGroupMoreBinding
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.util.CallbackResult
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class GroupMoreFunctionFragment : BaseSDKBottomDialog<PopupGroupMoreBinding, GroupViewModel>(
    R.layout.popup_group_more,
    GroupViewModel::class.java
) {

    private var neGroup: NeGroup? = null

    private val args: GroupMoreFunctionFragmentArgs by navArgs()

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_WRAP_CONTENT

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        binding.actionNoti.clickDebounce {
            neGroup?.let { _neGroup ->
                viewModel.groupActionNotification(
                    _neGroup,
                    callbackResult = object : CallbackResult<NeGroup> {
                        override fun callBackSuccess(result: NeGroup) {
                            dismiss()
                        }

                        override fun callBackError(error: String?) {
                            /**
                             * Need to define the solution for else case
                             */
                        }
                    }
                )
            }
        }

        binding.actionPin.clickDebounce {
            neGroup?.let { _neGroup ->
                viewModel.groupActionPin(
                    _neGroup,
                    callbackResult = object : CallbackResult<Boolean> {
                        override fun callBackSuccess(result: Boolean) {
                            dismiss()
                        }

                        override fun callBackError(error: String?) {
                            /**
                             * Need to define the solution for else case
                             */
                        }
                    }
                )
            }
        }

        binding.actionRead.clickDebounce {
            dismiss()
            /**
             * Waiting for the final solution
             */
        }

        binding.icClose.clickDebounce {
            dismiss()
        }
    }

    override fun initData() {
        neGroup?.let {
            binding.isMute = it.isMute
            binding.isPin = it.isPin
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        neGroup = args.neGroup
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(ivMarkAsRead, ivNoti, ivPin)
        }
    }
}
