package com.netacom.full.ui.main.group

import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupImageActionBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class ImageActionDialog : BaseSDKBottomDialog <PopupImageActionBinding, GroupViewModel>(R.layout.popup_image_action, GroupViewModel::class.java) {

    // val args: ImageActionDialogArgs by navArgs()

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_SMALL

    override fun initViews() {
    }

    override fun initData() {
        binding.llForward.clickDebounce {
            dismiss()
            viewModel.postActionImage(ViewMediaFragment.Action.FORWARD)
        }

        binding.llShare.clickDebounce {
            dismiss()
            viewModel.postActionImage(ViewMediaFragment.Action.SHARE)
        }
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(binding.ivForward, binding.ivShare)
    }
}
