package com.netacom.full.ui.main.group

import android.graphics.Color
import android.view.View
import android.widget.Toast
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.logger.Logger
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraBottomDialog
import com.netacom.full.databinding.FragmentChatInfoBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.lite.define.SyncType
import com.netacom.lite.entity.ui.NeChatInfo
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.util.CallbackResult
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

@AndroidEntryPoint
class MemberInfoDialog : BaseCoreCallCameraBottomDialog<FragmentChatInfoBinding, GroupViewModel>(
    R.layout.fragment_chat_info,
    GroupViewModel::class.java
) {
    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    private val args: MemberInfoDialogArgs by navArgs()

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    private var neGroup: NeGroup? = null

    private var galleryFragment: GalleryFragment? = null

    override fun initViews() {
        val neUser = args.neUser
        if (viewModel.checkHidePhone) {
            neUser.phone = "**********"
        }
        binding.viewContainer.setBackgroundColor(Color.TRANSPARENT)

        binding.item = NeChatInfo(neUser)

        // binding.llInfoFooter.visibility = View.GONE
        binding.llChangeBackground.isGone = true
        mainSdkViewModel.listContact.value?.peekContent()?.let {
            neUser.id?.let { id ->
                when {
                    ContactUtils.hasAddedFriend(id, it) -> {
                        binding.layoutContact.visibility = View.VISIBLE
                        binding.layoutMakeFriend.visibility = View.GONE
                    }
                    else -> {
                        binding.layoutContact.visibility = View.GONE
                        binding.layoutMakeFriend.visibility = View.VISIBLE
                        binding.toolbar.getTextRight()?.visibility = View.GONE
                    }
                }

                viewModel.getGroupOneToOneByUserId(
                    id,
                    object : CallbackResult<NeGroup> {
                        override fun callBackSuccess(_neGroup: NeGroup) {
                            this@MemberInfoDialog.neGroup = _neGroup
                            Logger.d("user mute : ${_neGroup.isMute}")
                            _neGroup.id?.let { groupId ->
                                setupGalleryFragment(_neGroup)
                                MainScope().launch {
                                    checkNotification(_neGroup.isMute)
                                    binding.llBlockOrLeave.isVisible = true
                                    _neGroup.blockers?.let {
                                        if (it.isEmpty()) {
                                            binding.tvLeaveOrBlock.text = getString(R.string.block_alert_button)
                                        } else {
                                            binding.tvLeaveOrBlock.text = getString(R.string.unblock_alert_button)
                                        }
                                    }
                                }
                            } ?: kotlin.run {
                                binding.llBlockOrLeave.isGone = true
                            }
                        }

                        override fun callBackError(error: String?) {
                            MainScope().launch {
                                binding.llBlockOrLeave.isGone = true
                            }
                        }
                    }
                )
            }
        }

        binding.llNotify.isVisible = viewModel.userHasConversation(neUser)

        mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
        binding.toolbar.setOnLeftClickListener {
            dismiss()
        }

        binding.imageViewAvatar.clickDebounce {
            binding.item?.let {
                viewModel.displayImage(it.getDisplayAvatar)
            }
        }

        binding.ivStartChat.clickDebounce {
            viewModel.startOneByOneChat(neUser)
        }

        binding.imgVideoCall.clickDebounce {
            neUser.id?.let { id -> checkCall(id, isVideoEnable = true) }
        }

        binding.imgVoiceCall.clickDebounce {
            neUser.id?.let { id -> checkCall(id, isVideoEnable = false) }
        }

        binding.layoutMakeFriend.clickDebounce {
            viewModel.showAddMember(neUser)
        }

        binding.llBlockOrLeave.clickDebounce {
            Toast.makeText(context, "Function is building...", Toast.LENGTH_SHORT).show()
        }

        binding.llSecretMessage.clickDebounce {
            mainSdkViewModel.startSecretChat(neUser)
        }

        binding.toolbar.setOnRightClickListener {
            binding.item?.let { neChatInfo ->
                viewModel.goToEditGroupOrPartnerInfo(neChatInfo)
            }
        }

        binding.llNotify.clickDebounce {
            neGroup?.let { neGroup ->
                viewModel.groupActionNotification(
                    neGroup = neGroup,
                    callbackResult = object : CallbackResult<NeGroup> {
                        override fun callBackSuccess(_neGroup: NeGroup) {
                            this@MemberInfoDialog.neGroup = _neGroup
                            checkNotification(_neGroup.isMute)
                        }

                        override fun callBackError(error: String?) {
                        }
                    }
                )
            }
        }

        binding.createGroupOrAddMember.clickDebounce {
            viewModel.openCreateGroupDialog(neUser)
        }
    }

    override fun initData() {
        callEvent()
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(
                ivStartChat, imgVoiceCall, imgVideoCall, ivSearchMessage,
                ivCreateGroupOrAddMember, ivShare, ivSecretChat, ivNotify, textViewTitle, toolbar.getButtonLeft()!!,
                txtTimeAgo, tvAddContactPhoneBook, ivGroupQrCode
            )
        }
    }

    private fun checkNotification(isMute: Boolean) {
        MainScope().launch {
            binding.isMute = isMute
        }
    }

    private fun setupGalleryFragment(group: NeGroup) {
        if (galleryFragment == null) {
            galleryFragment = GalleryFragment().apply {
                this.setGroup(group)
                this.setIsViewMedia(false)
                this.setIsViewSingle(true)
            }
            childFragmentManager.beginTransaction().add(R.id.flGallery, galleryFragment!!).commit()
        }
    }
}
