package com.netacom.full.ui.main.group

import androidx.core.view.isVisible
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewMemberListPopupBinding
import com.netacom.full.ui.main.chat.adapter.MemberChatInfoAdapter
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.sdk.AppID
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class MemberListDialog : BaseSDKBottomDialog<ViewMemberListPopupBinding, GroupViewModel>(
    R.layout.view_member_list_popup,
    GroupViewModel::class.java
) {
    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    val args: MemberListDialogArgs by navArgs()

    lateinit var neGroup: NeGroup

    var listMemberInGroup = mutableListOf<NeUser>()

    private lateinit var memberAdapter: MemberChatInfoAdapter

    override fun initViews() {
        neGroup = args.neGroup!!
        memberAdapter = MemberChatInfoAdapter(
            { item, _, _ ->
                run {
                    if (viewModel.appId() == AppID.GALO) {
                        if (preferencesHelperImpl.getUserId == args.leaderId) {
                            viewModel.showSingleMember(neUser = item)
                        }
                    } else {
                        viewModel.showSingleMember(neUser = item)
                    }
                }
            },
            {
                showSnackBar(R.string.text_message_this_is_you)
            },
            args.leaderId,
            themeHelperImpl = themeHelperImpl,
            {
                // remove member
                user ->
                viewModel.removeMember(user, neGroup)
            },
            preferencesHelperImpl = preferencesHelperImpl,
            isChannel = neGroup.type == GroupType.GROUP_TYPE_CHANNEL
        )

        if (neGroup.type == GroupType.GROUP_TYPE_CHANNEL) {
            binding.tvTitle.text = StringUtils.getString(R.string.flowers_list)
            binding.tvAddMember.text = getString(R.string.text_add_followers)
            binding.addMember.isVisible = viewModel.isLeaderInGroup(neGroup)
        }
        neGroup.members?.let {
            addMembers(it)
        }

        binding.rcvMember.apply {
            adapter = memberAdapter
        }

        binding.icClose.clickDebounce {
            dismiss()
        }

        binding.addMember.clickDebounce {
            viewModel.showAddMemberDialog(neGroup)
        }

        viewModel.updateGroup.observe {
            val updateNeGroup = it.peekContent()
            if (neGroup.id == updateNeGroup.id) {
                neGroup = updateNeGroup
                updateNeGroup.members?.let { listNeUser ->
                    addMembers(listNeUser)
                }
            }
        }
    }

    override fun initData() {
    }

    private fun addMembers(members: List<NeUser>) {
        listMemberInGroup.clear()

        members.find {
            it.id == args.leaderId
        }?.run {
            listMemberInGroup.add(this)
        }
        listMemberInGroup.addAll(
            members.filter {
                it.id != args.leaderId
            }.toList()
        )

        memberAdapter.display(listMemberInGroup)
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(icClose, tvAddMember, ivAddMember)
            themeHelperImpl.setThemeColorForSubBackground(ivAddMember)
        }
    }
}
