package com.netacom.full.ui.main.group

import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.PopupSaveImageBinding

class SaveImageDialog : BaseSDKBottomDialog <PopupSaveImageBinding, GroupViewModel>(R.layout.popup_save_image, GroupViewModel::class.java) {
    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_SMALL

    override fun initViews() {
        binding.tvSave.clickDebounce {
            dismiss()
            viewModel.postActionImage(ViewMediaFragment.Action.DOWNLOAD)
        }

        binding.tvCancel.clickDebounce {
            dismiss()
        }
    }

    override fun initData() {
    }

    override fun setupTheme() {
    }
}
