package com.netacom.full.ui.main.group.adapter

import android.view.View
import com.netacom.base.chat.adapter.BaseSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvNewMemberBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser

class AddMemberAdapter(
    itemClick: ((NeUser, View, Int) -> Unit)?,
    private val onRemoveMemeber: ((NeUser, View, Int) -> Unit)?,
    private val themeHelperImpl: ThemeHelperImpl? = null
) : BaseSimpleAdapter<NeUser, ItemRcvNewMemberBinding>(itemClick) {

    override val layout: Int
        get() = R.layout.item_rcv_new_member

    override fun bind(
        item: NeUser,
        holder: BaseViewHolder<ItemRcvNewMemberBinding>,
        position: Int
    ) {
        with(holder.binding) {
            ivMemberAvatar.setImageDrawable(null)
            this.item = item
            Logger.d("display avatar : ${item.getDisplayAvatar}")
            themeHelperImpl?.setThemeColorForBackground(ivClose)
            ivClose.clickDebounce {
                onRemoveMemeber?.invoke(item, it, position)
            }
        }
    }

    fun addMember(neUser: NeUser): Int {
        data.find {
            it.id == neUser.id
        }.run {
            if (this.isNotNull) {
                val index = data.indexOf(this)
                data.set(index, neUser)
            } else {
                add(neUser)
            }
        }

        return data.size
    }

    fun removeMember(neUser: NeUser): Int {
        remove(neUser)
        return data.size
    }
}
