package com.netacom.full.ui.main.group.adapter

import android.view.View
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.view.isGone
import androidx.core.view.isVisible
import com.netacom.full.R
import com.netacom.full.ui.main.contact.model.ItemNeContact
import com.netacom.full.ui.main.contact.model.SubNeContact
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser

class ChooseOwnerAdapter(
    itemClick: ((SubNeContact, View, Int) -> Unit)?,
    private val checkClick: ((NeUser, Int, Boolean) -> Unit),
    private val themeHelperImpl: ThemeHelperImpl
) : CreateGroupAdapter(itemClick, checkClick, themeHelperImpl, isChangeOwner = true) {

    override fun checkClickCheckBox(
        itemMember: ItemNeContact,
        ivCheck: AppCompatImageView,
        tvOwnerCheck: AppCompatTextView,
        position: Int
    ) {
        if (itemMember.isChecked()) {
            /*
            * check -> uncheck
            * */
            ivCheck.setImageBitmap(null)
            tvOwnerCheck.isGone = true
            itemMember.setChecked(false)
            getItem(position)?._itemNeContact?._checked = false
            itemMember._neContact?.let { data ->
                checkClick(data, position, false)
            }
            // notifyDataSetChanged()
        } else {
            /*
            * uncheck -> check
            * */
            ivCheck.setImageResource(R.drawable.ic_single_check)
            tvOwnerCheck.isVisible = true
            itemMember.setChecked(true)
            getItem(position)?._itemNeContact?._checked = true
            getData.forEach {
                if (it != getItem(position)) {
                    it._itemNeContact?._checked = false
                }
            }
            itemMember._neContact?.let { data ->
                checkClick(data, position, true)
            }
            notifyDataSetChanged()
        }
    }
}
