package com.netacom.full.ui.main.group.adapter

import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.LifecycleCoroutineScope
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseMultiTypeListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.util.unAccentText
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvUserGroupBinding
import com.netacom.full.databinding.ItemRcvUserGroupHeaderBinding
import com.netacom.full.ui.main.contact.ContactUtils
import com.netacom.full.ui.main.contact.model.ItemNeContact
import com.netacom.full.ui.main.contact.model.SubNeContact
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.user.NeUser
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

open class CreateGroupAdapter(
    itemClick: ((SubNeContact, View, Int) -> Unit)?,
    private val checkClick: ((NeUser, Int, Boolean) -> Unit),
    private val themeHelperImpl: ThemeHelperImpl,
    private val memberAdded: NeUser? = null,
    private val isChangeOwner: Boolean = false,
    val emptyCallBack: ((Boolean) -> Unit)? = null
) : BaseMultiTypeListSimpleAdapter<SubNeContact, ViewDataBinding>(itemClick, diff = NewGroupDiffUtil()) {
    companion object {
        private const val CONTACT_HEADER = 0
        private const val CONTACT_BODY = 1
    }

    private val neContacts = mutableListOf<NeUser>()

    override fun bindMultiType(position: Int): Int {
        return if (getItem(position)?.isHeader() == true) CONTACT_HEADER else CONTACT_BODY
    }

    fun setData(neContacts: List<NeUser>, lifecycleScope: LifecycleCoroutineScope) {
        this.neContacts.clear()
        this.neContacts.addAll(neContacts)
        lifecycleScope.launch(Dispatchers.IO) {
            val newList = ContactUtils.sortContacts(listContacts = neContacts)
            withContext(Dispatchers.Main) {
                display(newList)
            }
        }
    }

    fun getListDataChecked(): List<NeUser?> {
        return getData.filter {
            it.getItemUser()?.isChecked() ?: false
        }.map {
            it.getItemUser()?._neContact
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        return when (viewType) {
            CONTACT_HEADER -> BaseViewHolder(
                inflateView(parent, R.layout.item_rcv_user_group_header) as ItemRcvUserGroupHeaderBinding
            )
            CONTACT_BODY -> BaseViewHolder(
                inflateView(parent, R.layout.item_rcv_user_group) as ItemRcvUserGroupBinding
            )
            else -> BaseViewHolder(
                inflateView(parent, R.layout.item_rcv_user_group) as ItemRcvUserGroupBinding
            )
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        getItem(position)?.let { item ->
            with(holder) {
                when (getItemViewType(position)) {
                    CONTACT_HEADER -> bindContactHeader(
                        this,
                        subNeContact = item
                    )
                    CONTACT_BODY -> bindContactBody(
                        this,
                        _itemNeContact = item._itemNeContact,
                        isDivider = (layoutPosition != (itemCount - 1)),
                        position
                    )
                }
                binding.executePendingBindings()
            }
        }
    }

    private fun bindContactHeader(
        holder: BaseViewHolder<ViewDataBinding>,
        subNeContact: SubNeContact
    ) {
        with(holder.binding as ItemRcvUserGroupHeaderBinding) {
            this.header = subNeContact._neHeader ?: "#"
        }
    }

    private fun bindContactBody(
        holder: BaseViewHolder<ViewDataBinding>,
        _itemNeContact: ItemNeContact?,
        isDivider: Boolean,
        position: Int
    ) {
        with(holder.binding as ItemRcvUserGroupBinding) {
            ivAvatar.setImageDrawable(null)
            this.item = _itemNeContact?._neContact
            this.hasDivider = isDivider
            themeHelperImpl.setThemeColorForViews(ivCheck, tvOwner)

            if (_itemNeContact?.isChecked() == true) {
                this.ivCheck.setImageResource(R.drawable.ic_vector_check)
                if (isChangeOwner) this.tvOwner.isVisible = true
                else this.tvOwner.isGone = true
            } else {
                this.ivCheck.setImageBitmap(null)
                this.tvOwner.isGone = true
            }

            this.btnCheckbox.clickDebounce {
                _itemNeContact?.let { itemNeContact ->
                    checkClickCheckBox(
                        itemMember = itemNeContact,
                        ivCheck = this.ivCheck,
                        tvOwnerCheck = this.tvOwner,
                        position = position
                    )
                }
            }
        }
    }

    open fun checkClickCheckBox(
        itemMember: ItemNeContact,
        ivCheck: AppCompatImageView,
        tvOwnerCheck: AppCompatTextView,
        position: Int
    ) {

        if (itemMember.isChecked()) {
            /*
            * check -> uncheck
            * */
            itemMember.setChecked(false)
            ivCheck.setImageBitmap(null)
            tvOwnerCheck.isGone = true
            getItem(position)?._itemNeContact?._checked = false
            itemMember._neContact?.let { data ->
                checkClick(data, position, false)
            }
            // notifyDataSetChanged()
        } else {
            /*
            * uncheck -> check
            * */
            itemMember.setChecked(true)
            ivCheck.setImageResource(R.drawable.ic_single_check)
            if (isChangeOwner) tvOwnerCheck.isVisible = true
            else tvOwnerCheck.isGone = true
            getItem(position)?._itemNeContact?._checked = true
            itemMember._neContact?.let { data ->
                checkClick(data, position, true)
            }
        }
    }

    fun checkItem(neUser: NeUser) {
        getData.forEachIndexed { index, subNeContact ->
            if (subNeContact._itemNeContact?._neContact?.id == neUser.id) {
                subNeContact._itemNeContact?._checked = true
                // getData.toMutableList().replace(subNeContact) = subNeContact
                notifyItemChanged(index, subNeContact)
                subNeContact._itemNeContact?._neContact?.let { neUser ->
                    checkClick(neUser, index, true)
                }
            }
        }
    }

    fun unCheckItem(neUser: NeUser) {
        getData.find {
            it._itemNeContact?._neContact?.id == neUser.id
        }.run {
            this?._itemNeContact?._checked = false
            val position = getData.indexOf(this)
            notifyItemChanged(position)
        }
    }

    fun filter(filterBy: String, lifecycleScope: LifecycleCoroutineScope) {
        lifecycleScope.launch(Dispatchers.IO) {
            val termContact = neContacts.filter {
                var result: Boolean
                result = it.getDisplayName.unAccentText()?.contains(
                    filterBy,
                    ignoreCase = true
                ) ?: false
                if (!result) {
                    result = it.phone?.contains(filterBy, ignoreCase = true) == true
                }
                Logger.d("_InviteFriendAdapter result = $result")
                result
            }

            val newList = ContactUtils.sortContacts(listContacts = termContact)
            withContext(Dispatchers.Main) {
                emptyCallBack?.let { callback ->
                    callback(newList.isEmpty())
                }
                display(newList)
            }
        }
    }

    class NewGroupDiffUtil : DiffUtil.ItemCallback<SubNeContact>() {
        override fun areItemsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            return if (oldItem.isHeader() && newItem.isHeader()) {
                true
            } else !oldItem.isHeader() && !newItem.isHeader()
        }

        override fun areContentsTheSame(oldItem: SubNeContact, newItem: SubNeContact): Boolean {
            if (!oldItem.isHeader() && !newItem.isHeader()) {
                return oldItem._itemNeContact?._neContact?.phone == newItem._itemNeContact?._neContact?.phone
            }
            return false
        }
    }
}
