package com.netacom.full.ui.main.group.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.ItemRcvFileGalleryBinding
import com.netacom.full.databinding.ItemRcvPhotoVideoGalleryBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.define.MessageType
import com.netacom.lite.entity.ui.media.NeMedia
import com.netacom.lite.util.Constants
import com.netacom.lite.util.getUrlImage

class GalleryAdapter(
    itemClick: ((NeMedia, View, Int) -> Unit)?,
    var viewType: Int,
    private val themeHelperImpl: ThemeHelperImpl,
    private val isSecretChat: Boolean = false
) : BaseListSimpleAdapter<NeMedia, ViewDataBinding>(itemClick, diff = DiffCallBack()) {

    override val layout: Int
        get() = if (viewType == MessageType.MESSAGE_TYPE_FILE) R.layout.item_rcv_file_gallery
        else R.layout.item_rcv_photo_video_gallery

    private var layoutInflater: LayoutInflater? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        val customLayout = if (this.viewType == MessageType.MESSAGE_TYPE_FILE) {
            R.layout.item_rcv_file_gallery
        } else {
            R.layout.item_rcv_photo_video_gallery
        }

        if (layoutInflater == null) layoutInflater = LayoutInflater.from(parent.context)
        val binding: ViewDataBinding = DataBindingUtil.inflate(layoutInflater!!, customLayout, parent, false)
        return BaseViewHolder(binding)
    }

    fun displayList(list: List<NeMedia>, viewType: Int) {
        this.viewType = viewType
        display(
            list.asSequence().filter {
                it.mediaType == this.viewType
            }.toList()
        )
    }

    override fun bind(item: NeMedia, holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        if (item.mediaType == this.viewType) {
            when (item.mediaType) {
                MessageType.MESSAGE_TYPE_IMAGE, MessageType.MESSAGE_TYPE_VIDEO -> {
                    with(holder.binding as ItemRcvPhotoVideoGalleryBinding) {
                        if (item.mediaType == MessageType.MESSAGE_TYPE_IMAGE) {
                            val itemMediaUid: String?
                            if (isSecretChat) {
                                val localImageSecretPathHasUin = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.messId}/${item.mediaUid}"
                                val localImageSecretPathWithIndex = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.messId}/$position"
                                itemMediaUid = when {
                                    FileUtils.isFileExists(localImageSecretPathHasUin) -> {
                                        localImageSecretPathHasUin
                                    }
                                    FileUtils.isFileExists(localImageSecretPathWithIndex) -> {
                                        localImageSecretPathWithIndex
                                    }
                                    else -> item.mediaUid
                                }
                            } else {
                                itemMediaUid = if (item.mediaUid.split("/").size > 2) {
                                    item.mediaUid
                                } else {
                                    item.mediaUid.getUrlImage()
                                }
                            }
                            ivPhoto.loadImage(itemMediaUid, corner = 1f)
                        } else {
                            if (isSecretChat) {
                                val localThumbnailSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.messId}/${Constants.VIDEO_THUMBNAIL}"
                                val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${item.messId}/0"
                                when {
                                    FileUtils.isFileExists(localThumbnailSecretPath) -> {
                                        ivPhoto.loadImage(FileUtils.getFileByPath(localThumbnailSecretPath), corner = 1f)
                                    }
                                    FileUtils.isFileExists(localVideoSecretPath) -> {
                                        ivPhoto.loadImage(FileUtils.getFileByPath(localVideoSecretPath), corner = 1f)
                                    }
                                    else -> {
                                        ivPhoto.loadImage(item.mediaUid.getUrlImage(), corner = 1f)
                                    }
                                }
                            } else {
                                item.attachments?.video?.thumbnailUrl?.let { thumbnail ->
                                    ivPhoto.loadImage(thumbnail.getUrlImage(), corner = 1f)
                                } ?: let {
                                    ivPhoto.loadImage(item.mediaUid.getUrlImage(), corner = 1f)
                                }
                            }
                            ivTakePhoto.isVisible = true
                            ivTakePhoto.setImageResource(R.drawable.ic_video_play_btn)
                        }
                    }
                }

                MessageType.MESSAGE_TYPE_FILE -> {
                    with(holder.binding as ItemRcvFileGalleryBinding) {
                        this.item = item
                        themeHelperImpl.setThemeColorForViews(ivItemFile)
                    }
                }
            }
        }
    }

    private class DiffCallBack : DiffUtil.ItemCallback<NeMedia>() {

        override fun areItemsTheSame(oldItem: NeMedia, newItem: NeMedia): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(oldItem: NeMedia, newItem: NeMedia): Boolean {
            return oldItem.mediaType == newItem.mediaType && oldItem.msgCreateAt == newItem.msgCreateAt && oldItem.attachments == newItem.attachments
        }
    }
}
