/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.group.adapter

import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.R
import com.netacom.full.databinding.ItemGroupBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.define.GroupType
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.entity.ui.user.NeUser

/**
Created by vantoan on 04/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

class ListGroupAdapter(
    private val currentId: Long,
    private val languageApp: String,
    private val groupClick: ((NeGroup) -> Unit),
    private val moreClick: ((NeGroup) -> Unit),
    private val removeClick: ((NeGroup) -> Unit),
    private val themeHelperImpl: ThemeHelperImpl
) : BaseListSimpleAdapter<NeGroup, ItemGroupBinding>(diff = GroupDiff()) {

    override fun bind(item: NeGroup, holder: BaseViewHolder<ItemGroupBinding>, position: Int) {
        with(holder.binding) {
            this.imgAvatar.setImageDrawable(null)
            this.neGroup = item
            this.pinColor = themeHelperImpl.subColor
            this.userId = currentId
            this.language = languageApp
            themeHelperImpl.setThemeColorForViews(imgCheck)
            layoutGroup.clickDebounce {
                groupClick.invoke(item)
            }
            actionMore.clickDebounce {
                if (swipeLayout.isOpen()) {
                    moreClick.invoke(item)
                }
            }
            actionRemove.clickDebounce {
                if (swipeLayout.isOpen()) {
                    removeClick.invoke(item)
                }
            }
        }
    }

    override val layout = R.layout.item_group

    fun updateStatus(userStatus: NeUser) {
        getData.filter { it.type != GroupType.GROUP_TYPE_GROUP }.mapIndexed { index, neGroup ->
            if (neGroup.members?.firstOrNull { neMember -> neMember.id == userStatus.id } != null) {
                neGroup.isOnline = userStatus.isOnline ?: false
                // Logger.e("updateStatus:Group=$index neGroup=${neGroup.getDisplayName}")
                notifyItemChanged(index, neGroup)
            }
        }
    }

    private class GroupDiff : DiffUtil.ItemCallback<NeGroup>() {

        override fun areItemsTheSame(oldItem: NeGroup, newItem: NeGroup): Boolean {
            return oldItem.id == newItem.id
        }

        override fun areContentsTheSame(oldItem: NeGroup, newItem: NeGroup): Boolean {
            return oldItem.getDisplayName == newItem.getDisplayName && oldItem.getDisplayAvatar == newItem.getDisplayAvatar &&
                oldItem.lastMessage?.id == newItem.lastMessage?.id && oldItem.isOnline == newItem.isOnline && oldItem.isPin == newItem.isPin &&
                oldItem.description == newItem.description && oldItem.members == newItem.members && oldItem.isMute == newItem.isMute && oldItem.owner?.id == newItem.owner?.id &&
                oldItem.unReadCount == newItem.unReadCount
        }
    }
}
