package com.netacom.full.ui.main.group.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.viewpager.widget.PagerAdapter
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.ItemViewPhotoPagerBinding
import com.netacom.lite.entity.ui.media.NeMedia
import com.netacom.lite.util.getUrlImage

class ViewPhotoPagerAdapter(
    private val context: Context,
    private val imageUrls: ArrayList<NeMedia>,
    private val isSecretChat: Boolean = false,
    private val longClick: ((NeMedia) -> Unit)
) : PagerAdapter() {

    override fun getCount(): Int {
        return imageUrls.size
    }

    override fun getItemPosition(`object`: Any): Int {
        return POSITION_NONE
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view === `object`
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val layoutInflater: LayoutInflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val binding: ItemViewPhotoPagerBinding = DataBindingUtil.inflate(
            layoutInflater,
            R.layout.item_view_photo_pager,
            null,
            false
        )

        binding.ivViewPhotoPager.setOnLongClickListener {
            longClick.invoke(imageUrls[position])
            false
        }

        imageUrls[position].let { neMedia ->
            val itemMediaUid: String?
            if (isSecretChat) {
                val localImageSecretPathHasUin = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMedia.messId}/${neMedia.mediaUid}"
                val localImageSecretPathWithIndex = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${neMedia.messId}/$position"
                itemMediaUid = when {
                    FileUtils.isFileExists(localImageSecretPathHasUin) -> {
                        localImageSecretPathHasUin
                    }
                    FileUtils.isFileExists(localImageSecretPathWithIndex) -> {
                        localImageSecretPathWithIndex
                    }
                    else -> neMedia.mediaUid
                }
            } else {
                itemMediaUid = if (neMedia.mediaUid.split("/").size > 2) {
                    neMedia.mediaUid
                } else {
                    neMedia.mediaUid.getUrlImage()
                }
            }
            binding.ivViewPhotoPager.loadImage(itemMediaUid, R.drawable.ic_image_holder)
        }
        binding.root.tag = position

        container.addView(binding.root)

        return binding.root
    }

    fun setData(images: List<NeMedia>) {
        imageUrls.clear()
        imageUrls.addAll(images.reversed())
        notifyDataSetChanged()
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        container.removeView(`object` as View)
    }
}
