package com.netacom.full.ui.main.group.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import androidx.viewpager.widget.PagerAdapter
import com.google.android.exoplayer2.ExoPlaybackException
import com.netacom.base.chat.android_utils.FileUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.ApiResponseError
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.util.isLocalLink
import com.netacom.base.chat.util.isNull
import com.netacom.full.R
import com.netacom.full.databinding.ItemViewVideoPagerBinding
import com.netacom.full.widget.video.IPlayerClickListener
import com.netacom.full.widget.video.IPlayerStateListener
import com.netacom.full.widget.video.PlayerExoHelper
import com.netacom.lite.entity.ui.media.NeMedia
import com.netacom.lite.repository.DownloadRepository
import com.netacom.lite.util.Constants
import com.netacom.lite.util.getUrlImage
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class ViewVideoPagerAdapter(
    private val context: Context,
    private val videoUrls: List<NeMedia>,
    private val token: String,
    private val isSecretChat: Boolean = false,
    private val downloadRepository: DownloadRepository,
    private val playerExoHelper: PlayerExoHelper
) : PagerAdapter() {

    override fun getCount(): Int {
        return videoUrls.size
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view === `object`
    }

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val layoutInflater: LayoutInflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val binding: ItemViewVideoPagerBinding = DataBindingUtil.inflate(
            layoutInflater,
            R.layout.item_view_video_pager,
            null,
            false
        )

        with(binding) {
            // get current item media
            val currentVideoItem = videoUrls[position]
            var isInitialize = false

            ivItemVideoPlay.clickDebounce {
                with(playerExoHelper) {
                    if (isPlaying()) {
                        pauseExoPlayer()
                        it.isVisible = true
                    } else {
                        if (isInitialize) {
                            playExoPlayer()
                        } else {
                            setupExoplayer(exoPlayerPager)
                            setPlayerClickListener(
                                object : IPlayerClickListener {
                                    override fun isShowController(isVisible: Boolean) {
                                        // to do
                                    }
                                }
                            )
                            setPlayerStateListener(
                                object : IPlayerStateListener {
                                    override fun onVideoPause() {
                                    }

                                    override fun onVideoResume() {
                                    }

                                    override fun onVideoLoading() {
                                        pbItemVideoLoading.isVisible = true
                                    }

                                    override fun onVideoEnd() {
                                        ivItemVideoPlay.isVisible = true
                                        isInitialize = false
                                    }

                                    override fun onVideoStarted() {
                                        pbItemVideoLoading.isGone = true
                                    }

                                    override fun onVideoError(error: ExoPlaybackException?) {
                                        ivItemVideoPlay.isVisible = true
                                        pbItemVideoLoading.isGone = true
                                    }

                                    override fun onVideoTracking(progress: Long, duration: Long) {
                                    }

                                    override fun onVideoSizeChanged(width: Int) {
                                    }
                                }
                            )
                            ivItemVideoPlay.isVisible = true
                            ivItemVideoThumbnail.isGone = true
                            it.isGone = true
                            isInitialize = true
                        }
                    }
                }

                currentVideoItem.mediaUid.let { mediaUrl ->
                    Logger.e("mediaUrl: $mediaUrl")
                    if (isSecretChat) {
                        pbItemVideoLoading.isVisible = true
                        val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${currentVideoItem.messId}/0"
                        if (FileUtils.isFileExists(localVideoSecretPath)) {
                            playerExoHelper.runExoPlayer(localVideoSecretPath, token = token)
                        } else {
                            CoroutineScope(Dispatchers.IO).launch {
                                downloadRepository.downloadFiles(arrayListOf(mediaUrl.getUrlImage())).collect {
                                    when (it) {
                                        is ApiResponseSuccess -> {
                                            val responseDownload = it.data
                                            responseDownload?.let { responseBody ->
                                                com.netacom.lite.util.FileUtils.saveEncryptedFileToLocal(
                                                    body = responseBody,
                                                    path = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${currentVideoItem.messId}",
                                                    fileName = "0"
                                                ).let { localVideoSecretPath ->
                                                    withContext(Dispatchers.Main) {
                                                        pbItemVideoLoading.isVisible = false
                                                        playerExoHelper.runExoPlayer(localVideoSecretPath, token = token)
                                                    }
                                                }
                                            }
                                        }
                                        is ApiResponseError -> {
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        val playUrl = if (mediaUrl.split("/").size > 2) {
                            mediaUrl
                        } else {
                            mediaUrl.getUrlImage()
                        }
                        playerExoHelper.runExoPlayer(playUrl, token = token)
                    }
                }
                // show or hide ui layout
                ivItemVideoPlay.isGone = true
            }

            ivItemVideoThumbnail.isVisible = true
            ivItemVideoPlay.isVisible = true
            pbItemVideoLoading.isGone = true

            // show thumbnail
            if (currentVideoItem.mediaUid.isLocalLink()) {
                ivItemVideoThumbnail.loadImage(currentVideoItem.mediaUid)
            } else {
                if (isSecretChat) {
                    val localThumbnailSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${currentVideoItem.messId}/${Constants.VIDEO_THUMBNAIL}"
                    val localVideoSecretPath = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${currentVideoItem.messId}/0"
                    if (FileUtils.isFileExists(localThumbnailSecretPath)) {
                        ivItemVideoThumbnail.loadImage(localThumbnailSecretPath)
                    } else {
                        pbItemVideoLoading.isVisible = true
                        CoroutineScope(Dispatchers.IO).launch {
                            downloadRepository.downloadFiles(arrayListOf(currentVideoItem.mediaUid.getUrlImage())).collect {
                                when (it) {
                                    is ApiResponseSuccess -> {
                                        val responseDownload = it.data
                                        responseDownload?.let { responseBody ->
                                            com.netacom.lite.util.FileUtils.saveEncryptedFileToLocal(
                                                body = responseBody,
                                                path = "${com.netacom.lite.util.FileUtils.secretFolderPath}/${currentVideoItem.messId}",
                                                Constants.VIDEO_THUMBNAIL
                                            ).let { localThumbnailSecretPath ->
                                                withContext(Dispatchers.Main) {
                                                    pbItemVideoLoading.isVisible = false
                                                    if (FileUtils.isFileExists(localThumbnailSecretPath)) {
                                                        ivItemVideoThumbnail.loadImage(localThumbnailSecretPath)
                                                    } else {
                                                        ivItemVideoThumbnail.loadImage(localVideoSecretPath)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    is ApiResponseError -> {
                                        withContext(Dispatchers.Main) {
                                            pbItemVideoLoading.isVisible = false
                                            ivItemVideoThumbnail.loadImage(localVideoSecretPath)
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if (currentVideoItem.attachments?.video?.thumbnailUrl.isNull) {
                        ivItemVideoThumbnail.loadImage(currentVideoItem.mediaUid.getUrlImage())
                    } else {
                        ivItemVideoThumbnail.loadImage(currentVideoItem.attachments?.video?.thumbnailUrl.getUrlImage())
                    }
                }
            }
            container.addView(root)
        }

        return binding.root
    }

    fun releasePlayer() {
        playerExoHelper.stopExoPlayer()
        playerExoHelper.releaseExoPlayer()
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        releasePlayer()
        container.removeView(`object` as View)
    }
}
