package com.netacom.full.ui.main.profile

import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.lifecycleScope
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentBlockListBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.profile.adapter.BlockedListAdapter
import com.netacom.full.utils.DialogUtil
import com.netacom.lite.define.SyncType
import com.netacom.lite.entity.ui.BlockedItem
import com.netacom.lite.entity.ui.group.NeGroup
import com.netacom.lite.util.CallbackResult
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

@AndroidEntryPoint
class BlockListFragment : BaseSDKDataFragment<FragmentBlockListBinding, ProfileViewModel>(
    R.layout.fragment_block_list,
    ProfileViewModel::class.java
) {
    private lateinit var blockedListAdapter: BlockedListAdapter

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        blockedListAdapter = BlockedListAdapter(
            { blockedUser, _, _ ->
                val titleUnblock = requireContext().resources.getString(R.string.unblock_alert_title, blockedUser.getUser.getDisplayName)
                val messageUnblock = requireContext().resources.getString(R.string.unblock_alert_message, blockedUser.getUser.getDisplayName)
                DialogUtil.show(
                    context = requireContext(),
                    titleStr = titleUnblock,
                    messageStr = messageUnblock,
                    cancelLabel = R.string.str_cancel,
                    okLabel = R.string.unblock_alert_button,
                    okFunc = {
                        blockedUser.getUser.id?.let { blockIds ->
                            viewModel.unblockUser(
                                blockedUser.groupId,
                                blockIds,
                                callbackResult = object : CallbackResult<NeGroup> {
                                    override fun callBackSuccess(result: NeGroup) {
                                        getBlockedList()
                                        showSnackBar(R.string.unblock_user_success)
                                    }

                                    override fun callBackError(error: String?) {
                                        showSnackBar(R.string.unblock_user_unsuccess)
                                    }
                                }
                            )
                        }
                    },
                    themeHelperImpl = themeHelperImpl
                )
            },
            themeHelperImpl
        )
        binding.recyclerView.apply {
            adapter = blockedListAdapter
        }

        mainSdkViewModel.listContact.observeOnce { listNeUser ->
            viewModel.filterContactHasConversation(listNeUser)
        }

        getBlockedList()
    }

    private fun getBlockedList() {
        viewModel.getBlockList(
            object : CallbackResult<List<BlockedItem>> {
                override fun callBackSuccess(result: List<BlockedItem>) {
                    lifecycleScope.launch(Dispatchers.Main) {
                        if (result.isEmpty()) {
                            binding.tvEmpty.isVisible = true
                        } else {
                            binding.tvEmpty.isGone = true
                            blockedListAdapter.display(result)
                        }
                    }
                }

                override fun callBackError(error: String?) {
                }
            }
        )

        mainSdkViewModel.syncContact(SyncType.LIST_SYNC_DB)
    }

    override fun initData() {
        binding.toolbar.setOnLeftClickListener {
            viewModel.onBack()
        }

        binding.llBlock.clickDebounce {
            viewModel.goToAddBlock()
        }
    }

    override fun syncEvent() {
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(
                imgChooseAvatar,
                tvInviteFiend,
                toolbar
            )
            themeHelperImpl.setThemeColorForSubBackground(imgChooseAvatar)
        }
    }
}
