package com.netacom.full.ui.main.profile

import androidx.core.view.isVisible
import androidx.lifecycle.lifecycleScope
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.BlockUserDialogBinding
import com.netacom.full.ui.main.group.adapter.CreateGroupAdapter
import com.netacom.lite.entity.ui.user.NeUser
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class BlockUserDialog : BaseSDKBottomDialog<BlockUserDialogBinding, ProfileViewModel>(R.layout.block_user_dialog, ProfileViewModel::class.java) {

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun setViewModel(): Int = BR.viewModel

    private lateinit var contactAdapter: CreateGroupAdapter

    private var totalList = 0
    private val addedBlockList = mutableListOf<NeUser>()
    override fun initViews() {
        contactAdapter = CreateGroupAdapter(
            (
                { _, _, _ ->
                }
                ),
            { neContact: NeUser, _: Int, isCheck: Boolean ->
                if (isCheck) {
                    addedBlockList.add(neContact)
                } else {
                    addedBlockList.remove(neContact)
                }
                checkList(addedBlockList)
            },
            themeHelperImpl
        )
        binding.recyclerView.adapter = contactAdapter
    }

    override fun initData() {
        viewModel.contactHasConversation.observe { listUserHasConversation ->
            contactAdapter.setData(
                listUserHasConversation.peekContent(),
                lifecycleScope = lifecycleScope
            )
            totalList = listUserHasConversation.peekContent().size
            checkList(addedBlockList)
        }

        binding.tvCancel.clickDebounce {
            dismiss()
        }

        binding.tvDone.clickDebounce {
        }
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(binding.tvDone)
        }
    }

    private fun checkList(addedList: List<NeUser>) {
        binding.tvCount.text = String.format(
            requireContext().resources.getString(R.string.str_block_user_count),
            addedList.size,
            totalList
        )
        binding.tvDone.isVisible = addedList.isNotEmpty()
        binding.tvDone.text = String.format(
            requireContext().resources.getString(R.string.str_block_user_btn),
            addedList.size
        )
    }
}
