/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile

import android.annotation.SuppressLint
import android.webkit.WebChromeClient
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.fragment.app.activityViewModels
import androidx.navigation.fragment.navArgs
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentCampaignBinding
import com.netacom.full.ui.sdk.NetAloViewModel
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@AndroidEntryPoint
class CampaignFragment :
    BaseSDKDataFragment<FragmentCampaignBinding, ReferralViewModel>(
        R.layout.fragment_campaign,
        ReferralViewModel::class.java
    ) {
    override fun setViewModel(): Int = BR.viewModel
    private val netAloViewModel: NetAloViewModel by activityViewModels()
    private val args: CampaignFragmentArgs by navArgs()

    @SuppressLint("SetJavaScriptEnabled")
    override fun initViews() {
        with(binding) {
            webView.webViewClient = object : WebViewClient() {
                override fun onPageFinished(view: WebView?, url: String?) {
                    super.onPageFinished(view, url)
                    if (activity?.isFinishing == false && view != null) {
                        binding.progressLoading.isGone = true
                    }
                }
            }
            webView.webChromeClient = object : WebChromeClient() {
                override fun onProgressChanged(view: WebView?, newProgress: Int) {
                    super.onProgressChanged(view, newProgress)
                    if (newProgress == 100 && activity?.isFinishing == false && view != null) {
                        binding.progressLoading.isGone = true
                    }
                }
            }
            webView.setBackgroundColor(ContextCompat.getColor(requireContext(), R.color.color_green_gchat))
            webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null)
            webView.settings.javaScriptEnabled = true
            webView.settings.domStorageEnabled = true
            args.url?.apply {
                webView.loadUrl(this)
            }
        }
    }

    override fun initData() {
    }

    override fun syncEvent() {
    }

    override fun setupTheme() {
    }

    override fun onDestroyView() {
        with(binding) {
            webView.destroy()
        }
        netAloViewModel.showNextReferral()
        super.onDestroyView()
    }
}
